/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.visualization.svg.SVGEffects;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class SVGCheckbox {
    protected boolean checked;
    protected EventListenerList listenerList = new EventListenerList();
    protected String label = null;

    public SVGCheckbox(boolean checked) {
        this(checked, null);
    }

    public SVGCheckbox(boolean checked, String label) {
        this.checked = checked;
        this.label = label;
    }

    public Element renderCheckBox(SVGPlot svgp, double x, double y, double size) {
        final Element checkmark = SVGEffects.makeCheckmark(svgp);
        checkmark.setAttribute("transform", "scale(" + size / 12.0 + ") translate(" + x + " " + y + ")");
        if (!this.checked) {
            checkmark.setAttribute("style", "display:none");
        }
        Element checkbox_box = SVGUtil.svgRect(svgp.getDocument(), x, y, size, size);
        checkbox_box.setAttribute("fill", "#d4e4f1");
        checkbox_box.setAttribute("stroke", "#a0a0a0");
        checkbox_box.setAttribute("stroke-width", "0.5");
        Element checkbox = svgp.svgElement("g");
        checkbox.appendChild(checkbox_box);
        checkbox.appendChild(checkmark);
        if (this.label != null) {
            Element labele = svgp.svgText(x + 2.0 * size, y + size, this.label);
            checkbox.appendChild(labele);
        }
        EventTarget targ = (EventTarget)((Object)checkbox);
        targ.addEventListener("click", new EventListener(){

            @Override
            public void handleEvent(Event evt) {
                if (SVGCheckbox.this.checked ^= true) {
                    checkmark.removeAttribute("style");
                } else {
                    checkmark.setAttribute("style", "display:none");
                }
                SVGCheckbox.this.fireSwitchEvent(new ChangeEvent(SVGCheckbox.this));
            }
        }, false);
        return checkbox;
    }

    public void addCheckBoxListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeCheckBoxListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public boolean isChecked() {
        return this.checked;
    }

    protected void fireSwitchEvent(ChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 1; i < listeners.length; i += 2) {
            if (listeners[i - 1] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i]).stateChanged(evt);
        }
    }
}

