/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import org.w3c.dom.Element;

public final class SVGEffects {
    public static final String SHADOW_ID = "shadow-effect";
    public static final String LIGHT_GRADIENT_ID = "light-gradient";
    public static final String SVG_CHECKMARK_PATH = "M0 6.458 L2.047 4.426 5.442 7.721 12.795 0 15 2.117 5.66 11.922 Z";

    private SVGEffects() {
    }

    public static void addShadowFilter(SVGPlot svgp) {
        Element shadow = svgp.getIdElement(SHADOW_ID);
        if (shadow == null) {
            shadow = svgp.svgElement("filter");
            shadow.setAttribute("id", SHADOW_ID);
            shadow.setAttribute("width", "140%");
            shadow.setAttribute("height", "140%");
            Element offset = svgp.svgElement("feOffset");
            offset.setAttribute("in", "SourceAlpha");
            offset.setAttribute("result", "off");
            offset.setAttribute("dx", "0.1");
            offset.setAttribute("dy", "0.1");
            shadow.appendChild(offset);
            Element gauss = svgp.svgElement("feGaussianBlur");
            gauss.setAttribute("in", "off");
            gauss.setAttribute("result", "blur");
            gauss.setAttribute("stdDeviation", "0.1");
            shadow.appendChild(gauss);
            Element blend = svgp.svgElement("feBlend");
            blend.setAttribute("in", "SourceGraphic");
            blend.setAttribute("in2", "blur");
            blend.setAttribute("mode", "normal");
            shadow.appendChild(blend);
            svgp.getDefs().appendChild(shadow);
            svgp.putIdElement(SHADOW_ID, shadow);
        }
    }

    public static void addLightGradient(SVGPlot svgp) {
        Element gradient = svgp.getIdElement(LIGHT_GRADIENT_ID);
        if (gradient == null) {
            gradient = svgp.svgElement("linearGradient");
            gradient.setAttribute("id", LIGHT_GRADIENT_ID);
            gradient.setAttribute("x1", "0");
            gradient.setAttribute("y1", "0");
            gradient.setAttribute("x2", "0");
            gradient.setAttribute("y2", "1");
            Element stop0 = svgp.svgElement("stop");
            stop0.setAttribute("stop-color", "white");
            stop0.setAttribute("stop-opacity", "1");
            stop0.setAttribute("offset", "0");
            gradient.appendChild(stop0);
            Element stop04 = svgp.svgElement("stop");
            stop04.setAttribute("stop-color", "white");
            stop04.setAttribute("stop-opacity", "0");
            stop04.setAttribute("offset", ".4");
            gradient.appendChild(stop04);
            Element stop06 = svgp.svgElement("stop");
            stop06.setAttribute("stop-color", "black");
            stop06.setAttribute("stop-opacity", "0");
            stop06.setAttribute("offset", ".6");
            gradient.appendChild(stop06);
            Element stop1 = svgp.svgElement("stop");
            stop1.setAttribute("stop-color", "black");
            stop1.setAttribute("stop-opacity", ".5");
            stop1.setAttribute("offset", "1");
            gradient.appendChild(stop1);
            svgp.getDefs().appendChild(gradient);
            svgp.putIdElement(LIGHT_GRADIENT_ID, gradient);
        }
    }

    public static Element makeCheckmark(SVGPlot svgp) {
        Element checkmark = svgp.svgElement("path");
        checkmark.setAttribute("d", SVG_CHECKMARK_PATH);
        checkmark.setAttribute("fill", "black");
        checkmark.setAttribute("stroke", "none");
        return checkmark;
    }
}

