/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public final class SVGHyperCube {
    private SVGHyperCube() {
    }

    public static Element drawFrame(SVGPlot svgp, Projection2D proj, double[] min, double[] max) {
        SVGPath path = new SVGPath();
        ArrayList<double[]> edges = SVGHyperCube.getVisibleEdges(proj, min, max);
        double[] rv_min = proj.fastProjectDataToRenderSpace(min);
        SVGHyperCube.recDrawEdges(path, rv_min[0], rv_min[1], edges, BitsUtil.zero(edges.size()));
        return path.makeElement(svgp);
    }

    public static Element drawFrame(SVGPlot svgp, Projection2D proj, NumberVector min, NumberVector max) {
        SVGPath path = new SVGPath();
        ArrayList<double[]> edges = SVGHyperCube.getVisibleEdges(proj, min, max);
        double[] rv_min = proj.fastProjectDataToRenderSpace(min);
        SVGHyperCube.recDrawEdges(path, rv_min[0], rv_min[1], edges, BitsUtil.zero(edges.size()));
        return path.makeElement(svgp);
    }

    public static Element drawFrame(SVGPlot svgp, Projection2D proj, SpatialComparable box) {
        SVGPath path = new SVGPath();
        ArrayList<double[]> edges = SVGHyperCube.getVisibleEdges(proj, box);
        int dim = box.getDimensionality();
        double[] min = new double[dim];
        for (int i = 0; i < dim; ++i) {
            min[i] = box.getMin(i);
        }
        double[] rv_min = proj.fastProjectDataToRenderSpace(min);
        SVGHyperCube.recDrawEdges(path, rv_min[0], rv_min[1], edges, BitsUtil.zero(edges.size()));
        return path.makeElement(svgp);
    }

    public static Element drawFilled(SVGPlot svgp, String cls, Projection2D proj, double[] min, double[] max) {
        Element group = svgp.svgElement("g");
        ArrayList<double[]> edges = SVGHyperCube.getVisibleEdges(proj, min, max);
        double[] rv_min = proj.fastProjectDataToRenderSpace(min);
        SVGHyperCube.recDrawSides(svgp, group, cls, rv_min[0], rv_min[1], edges, 0, BitsUtil.zero(edges.size()));
        return group;
    }

    public static Element drawFilled(SVGPlot svgp, String cls, Projection2D proj, NumberVector min, NumberVector max) {
        Element group = svgp.svgElement("g");
        ArrayList<double[]> edges = SVGHyperCube.getVisibleEdges(proj, min, max);
        double[] rv_min = proj.fastProjectDataToRenderSpace(min);
        SVGHyperCube.recDrawSides(svgp, group, cls, rv_min[0], rv_min[1], edges, 0, BitsUtil.zero(edges.size()));
        return group;
    }

    public static Element drawFilled(SVGPlot svgp, String cls, Projection2D proj, SpatialComparable box) {
        Element group = svgp.svgElement("g");
        ArrayList<double[]> edges = SVGHyperCube.getVisibleEdges(proj, box);
        int dim = box.getDimensionality();
        double[] min = new double[dim];
        for (int i = 0; i < dim; ++i) {
            min[i] = box.getMin(i);
        }
        double[] rv_min = proj.fastProjectDataToRenderSpace(min);
        SVGHyperCube.recDrawSides(svgp, group, cls, rv_min[0], rv_min[1], edges, 0, BitsUtil.zero(edges.size()));
        return group;
    }

    private static ArrayList<double[]> getVisibleEdges(Projection2D proj, double[] s_min, double[] s_max) {
        int dim = s_min.length;
        double[] s_deltas = VMath.minus(s_max, s_min);
        ArrayList<double[]> r_edges = new ArrayList<double[]>(dim);
        for (int i = 0; i < dim; ++i) {
            double[] delta = new double[dim];
            delta[i] = s_deltas[i];
            double[] deltas = proj.fastProjectRelativeDataToRenderSpace(delta);
            if (deltas[0] == 0.0 && deltas[1] == 0.0) continue;
            r_edges.add(deltas);
        }
        return r_edges;
    }

    private static ArrayList<double[]> getVisibleEdges(Projection2D proj, NumberVector s_min, NumberVector s_max) {
        int dim = s_min.getDimensionality();
        double[] s_deltas = new double[dim];
        for (int i = 0; i < dim; ++i) {
            s_deltas[i] = s_max.doubleValue(i) - s_min.doubleValue(i);
        }
        ArrayList<double[]> r_edges = new ArrayList<double[]>(dim);
        for (int i = 0; i < dim; ++i) {
            double[] delta = new double[dim];
            delta[i] = s_deltas[i];
            double[] deltas = proj.fastProjectRelativeDataToRenderSpace(delta);
            if (deltas[0] == 0.0 && deltas[1] == 0.0) continue;
            r_edges.add(deltas);
        }
        return r_edges;
    }

    private static ArrayList<double[]> getVisibleEdges(Projection2D proj, SpatialComparable box) {
        int dim = box.getDimensionality();
        double[] s_deltas = new double[dim];
        for (int i = 0; i < dim; ++i) {
            s_deltas[i] = box.getMax(i) - box.getMin(i);
        }
        ArrayList<double[]> r_edges = new ArrayList<double[]>(dim);
        for (int i = 0; i < dim; ++i) {
            double[] delta = new double[dim];
            delta[i] = s_deltas[i];
            double[] deltas = proj.fastProjectRelativeDataToRenderSpace(delta);
            if (deltas[0] == 0.0 && deltas[1] == 0.0) continue;
            r_edges.add(deltas);
        }
        return r_edges;
    }

    private static void recDrawEdges(SVGPath path, double minx, double miny, List<double[]> r_edges, long[] b) {
        for (int i = 0; i < r_edges.size(); ++i) {
            if (BitsUtil.get(b, i)) continue;
            double[] edge = r_edges.get(i);
            double x_i = minx + edge[0];
            double y_i = miny + edge[1];
            if (!SVGHyperCube.isFinite(x_i) || !SVGHyperCube.isFinite(y_i)) continue;
            path.moveTo(minx, miny).drawTo(x_i, y_i);
            BitsUtil.setI(b, i);
            SVGHyperCube.recDrawEdges(path, x_i, y_i, r_edges, b);
            BitsUtil.clearI(b, i);
        }
    }

    private static void recDrawSides(SVGPlot plot, Element group, String cls, double minx, double miny, List<double[]> r_edges, int off, long[] b) {
        StringBuilder pbuf = new StringBuilder();
        for (int i = 0; i < r_edges.size() - 1; ++i) {
            double yi;
            double[] deltai;
            double xi;
            if (BitsUtil.get(b, i) || !SVGHyperCube.isFinite(xi = minx + (deltai = r_edges.get(i))[0]) || !SVGHyperCube.isFinite(yi = miny + deltai[1])) continue;
            for (int j = i + 1; j < r_edges.size(); ++j) {
                if (BitsUtil.get(b, j)) continue;
                double[] deltaj = r_edges.get(j);
                double dxj = deltaj[0];
                if (!SVGHyperCube.isFinite(xi)) continue;
                double dyj = deltaj[1];
                if (!SVGHyperCube.isFinite(dxj)) continue;
                pbuf.delete(0, pbuf.length()).append(SVGUtil.fmt(minx)).append(',').append(SVGUtil.fmt(miny)).append(' ').append(SVGUtil.fmt(xi)).append(',').append(SVGUtil.fmt(yi)).append(' ').append(SVGUtil.fmt(xi + dxj)).append(',').append(SVGUtil.fmt(yi + dyj)).append(' ').append(SVGUtil.fmt(minx + dxj)).append(',').append(SVGUtil.fmt(miny + dyj));
                Element poly = plot.svgElement("polygon", cls);
                SVGUtil.setAtt(poly, "points", pbuf.toString());
                group.appendChild(poly);
            }
            BitsUtil.setI(b, i);
            SVGHyperCube.recDrawSides(plot, group, cls, xi, yi, r_edges, i + 1, b);
            BitsUtil.clearI(b, i);
        }
    }

    private static boolean isFinite(double v) {
        return v < Double.POSITIVE_INFINITY && v > Double.NEGATIVE_INFINITY;
    }
}

