/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import net.jafama.FastMath;
import org.w3c.dom.Element;

public final class SVGHyperSphere {
    public static final double EUCLIDEAN_KAPPA = 0.5522847498;

    private SVGHyperSphere() {
    }

    public static Element drawManhattan(SVGPlot svgp, Projection2D proj, NumberVector mid, double radius) {
        double[] v_mid = mid.toArray();
        long[] dims = proj.getVisibleDimensions2D();
        SVGPath path = new SVGPath();
        int dim = BitsUtil.nextSetBit(dims, 0);
        while (dim >= 0) {
            int n = dim;
            v_mid[n] = v_mid[n] + radius;
            double[] p1 = proj.fastProjectDataToRenderSpace(v_mid);
            int n2 = dim;
            v_mid[n2] = v_mid[n2] - radius * 2.0;
            double[] p2 = proj.fastProjectDataToRenderSpace(v_mid);
            int n3 = dim;
            v_mid[n3] = v_mid[n3] + radius;
            int dim2 = BitsUtil.nextSetBit(dims, 0);
            while (dim2 >= 0) {
                if (dim < dim2) {
                    int n4 = dim2;
                    v_mid[n4] = v_mid[n4] + radius;
                    double[] p3 = proj.fastProjectDataToRenderSpace(v_mid);
                    int n5 = dim2;
                    v_mid[n5] = v_mid[n5] - radius * 2.0;
                    double[] p4 = proj.fastProjectDataToRenderSpace(v_mid);
                    int n6 = dim2;
                    v_mid[n6] = v_mid[n6] + radius;
                    path.moveTo(p1[0], p1[1]).drawTo(p3[0], p3[1]).moveTo(p1[0], p1[1]).drawTo(p4[0], p4[1]).moveTo(p2[0], p2[1]).drawTo(p3[0], p3[1]).moveTo(p2[0], p2[1]).drawTo(p4[0], p4[1]).close();
                }
                dim2 = BitsUtil.nextSetBit(dims, dim2 + 1);
            }
            dim = BitsUtil.nextSetBit(dims, dim + 1);
        }
        return path.makeElement(svgp);
    }

    public static Element drawEuclidean(SVGPlot svgp, Projection2D proj, NumberVector mid, double radius) {
        double[] v_mid = mid.toArray();
        long[] dims = proj.getVisibleDimensions2D();
        SVGPath path = new SVGPath();
        int dim = BitsUtil.nextSetBit(dims, 0);
        while (dim >= 0) {
            int n = dim;
            v_mid[n] = v_mid[n] + radius;
            double[] p1 = proj.fastProjectDataToRenderSpace(v_mid);
            int n2 = dim;
            v_mid[n2] = v_mid[n2] - radius * 2.0;
            double[] p2 = proj.fastProjectDataToRenderSpace(v_mid);
            int n3 = dim;
            v_mid[n3] = v_mid[n3] + radius;
            double[] dt1 = new double[v_mid.length];
            dt1[dim] = radius;
            double[] d1 = proj.fastProjectRelativeDataToRenderSpace(dt1);
            int dim2 = BitsUtil.nextSetBit(dims, 0);
            while (dim2 >= 0) {
                if (dim < dim2) {
                    int n4 = dim2;
                    v_mid[n4] = v_mid[n4] + radius;
                    double[] p3 = proj.fastProjectDataToRenderSpace(v_mid);
                    int n5 = dim2;
                    v_mid[n5] = v_mid[n5] - radius * 2.0;
                    double[] p4 = proj.fastProjectDataToRenderSpace(v_mid);
                    int n6 = dim2;
                    v_mid[n6] = v_mid[n6] + radius;
                    double[] dt2 = new double[v_mid.length];
                    dt2[dim2] = radius;
                    double[] d2 = proj.fastProjectRelativeDataToRenderSpace(dt2);
                    path.moveTo(p1[0], p1[1]).cubicTo(p1[0] + d2[0] * 0.5522847498, p1[1] + d2[1] * 0.5522847498, p3[0] + d1[0] * 0.5522847498, p3[1] + d1[1] * 0.5522847498, p3[0], p3[1]).cubicTo(p3[0] - d1[0] * 0.5522847498, p3[1] - d1[1] * 0.5522847498, p2[0] + d2[0] * 0.5522847498, p2[1] + d2[1] * 0.5522847498, p2[0], p2[1]).cubicTo(p2[0] - d2[0] * 0.5522847498, p2[1] - d2[1] * 0.5522847498, p4[0] - d1[0] * 0.5522847498, p4[1] - d1[1] * 0.5522847498, p4[0], p4[1]).cubicTo(p4[0] + d1[0] * 0.5522847498, p4[1] + d1[1] * 0.5522847498, p1[0] - d2[0] * 0.5522847498, p1[1] - d2[1] * 0.5522847498, p1[0], p1[1]).close();
                }
                dim2 = BitsUtil.nextSetBit(dims, dim2 + 1);
            }
            dim = BitsUtil.nextSetBit(dims, dim + 1);
        }
        return path.makeElement(svgp);
    }

    public static Element drawLp(SVGPlot svgp, Projection2D proj, NumberVector mid, double radius, double p) {
        double[] v_mid = mid.toArray();
        long[] dims = proj.getVisibleDimensions2D();
        double kappax = p > 1.0 ? Math.min(1.3, 4.0 * (2.0 * FastMath.pow(0.5, 1.0 / p) - 1.0) / 3.0) : 0.0;
        double kappay = p < 1.0 ? Math.min(1.3, 4.0 * (2.0 * (1.0 - FastMath.pow(0.5, 1.0 / p)) - 1.0) / 3.0) : 0.0;
        SVGPath path = new SVGPath();
        int dim = BitsUtil.nextSetBit(dims, 0);
        while (dim >= 0) {
            int n = dim;
            v_mid[n] = v_mid[n] + radius;
            double[] pvp0 = proj.fastProjectDataToRenderSpace(v_mid);
            int n2 = dim;
            v_mid[n2] = v_mid[n2] - radius * 2.0;
            double[] pvm0 = proj.fastProjectDataToRenderSpace(v_mid);
            int n3 = dim;
            v_mid[n3] = v_mid[n3] + radius;
            double[] tvd0 = new double[v_mid.length];
            tvd0[dim] = radius;
            double[] vd0 = proj.fastProjectRelativeDataToRenderSpace(tvd0);
            int dim2 = BitsUtil.nextSetBit(dims, 0);
            while (dim2 >= 0) {
                if (dim < dim2) {
                    int n4 = dim2;
                    v_mid[n4] = v_mid[n4] + radius;
                    double[] pv0p = proj.fastProjectDataToRenderSpace(v_mid);
                    int n5 = dim2;
                    v_mid[n5] = v_mid[n5] - radius * 2.0;
                    double[] pv0m = proj.fastProjectDataToRenderSpace(v_mid);
                    int n6 = dim2;
                    v_mid[n6] = v_mid[n6] + radius;
                    double[] tv0d = new double[v_mid.length];
                    tv0d[dim2] = radius;
                    double[] v0d = proj.fastProjectRelativeDataToRenderSpace(tv0d);
                    if (p > 1.0) {
                        double s_pp1_x = pvp0[0] + v0d[0] * kappax;
                        double s_pp1_y = pvp0[1] + v0d[1] * kappax;
                        double s_pp2_x = pv0p[0] + vd0[0] * kappax;
                        double s_pp2_y = pv0p[1] + vd0[1] * kappax;
                        double s_mp1_x = pv0p[0] - vd0[0] * kappax;
                        double s_mp1_y = pv0p[1] - vd0[1] * kappax;
                        double s_mp2_x = pvm0[0] + v0d[0] * kappax;
                        double s_mp2_y = pvm0[1] + v0d[1] * kappax;
                        double s_mm1_x = pvm0[0] - v0d[0] * kappax;
                        double s_mm1_y = pvm0[1] - v0d[1] * kappax;
                        double s_mm2_x = pv0m[0] - vd0[0] * kappax;
                        double s_mm2_y = pv0m[1] - vd0[1] * kappax;
                        double s_pm1_x = pv0m[0] + vd0[0] * kappax;
                        double s_pm1_y = pv0m[1] + vd0[1] * kappax;
                        double s_pm2_x = pvp0[0] - v0d[0] * kappax;
                        double s_pm2_y = pvp0[1] - v0d[1] * kappax;
                        path.moveTo(pvp0[0], pvp0[1]).cubicTo(s_pp1_x, s_pp1_y, s_pp2_x, s_pp2_y, pv0p[0], pv0p[1]).cubicTo(s_mp1_x, s_mp1_y, s_mp2_x, s_mp2_y, pvm0[0], pvm0[1]).cubicTo(s_mm1_x, s_mm1_y, s_mm2_x, s_mm2_y, pv0m[0], pv0m[1]).cubicTo(s_pm1_x, s_pm1_y, s_pm2_x, s_pm2_y, pvp0[0], pvp0[1]).close();
                    } else if (p < 1.0) {
                        double s_vp0_x = pvp0[0] - vd0[0] * kappay;
                        double s_vp0_y = pvp0[1] - vd0[1] * kappay;
                        double s_v0p_x = pv0p[0] - v0d[0] * kappay;
                        double s_v0p_y = pv0p[1] - v0d[1] * kappay;
                        double s_vm0_x = pvm0[0] + vd0[0] * kappay;
                        double s_vm0_y = pvm0[1] + vd0[1] * kappay;
                        double s_v0m_x = pv0m[0] + v0d[0] * kappay;
                        double s_v0m_y = pv0m[1] + v0d[1] * kappay;
                        path.moveTo(pvp0[0], pvp0[1]).cubicTo(s_vp0_x, s_vp0_y, s_v0p_x, s_v0p_y, pv0p[0], pv0p[1]).cubicTo(s_v0p_x, s_v0p_y, s_vm0_x, s_vm0_y, pvm0[0], pvm0[1]).cubicTo(s_vm0_x, s_vm0_y, s_v0m_x, s_v0m_y, pv0m[0], pv0m[1]).cubicTo(s_v0m_x, s_v0m_y, s_vp0_x, s_vp0_y, pvp0[0], pvp0[1]).close();
                    } else {
                        path.moveTo(pvp0[0], pvp0[1]).lineTo(pv0p[0], pv0p[1]).lineTo(pvm0[0], pvm0[1]).lineTo(pv0m[0], pv0m[1]).lineTo(pvp0[0], pvp0[1]).close();
                    }
                }
                dim2 = BitsUtil.nextSetBit(dims, dim2 + 1);
            }
            dim = BitsUtil.nextSetBit(dims, dim + 1);
        }
        return path.makeElement(svgp);
    }

    public static Element drawCross(SVGPlot svgp, Projection2D proj, NumberVector mid, double radius) {
        double[] v_mid = mid.toArray();
        long[] dims = proj.getVisibleDimensions2D();
        SVGPath path = new SVGPath();
        int dim = BitsUtil.nextSetBit(dims, 0);
        while (dim >= 0) {
            int n = dim;
            v_mid[n] = v_mid[n] + radius;
            double[] p1 = proj.fastProjectDataToRenderSpace(v_mid);
            int n2 = dim;
            v_mid[n2] = v_mid[n2] - radius * 2.0;
            double[] p2 = proj.fastProjectDataToRenderSpace(v_mid);
            int n3 = dim;
            v_mid[n3] = v_mid[n3] + radius;
            path.moveTo(p1[0], p1[1]).drawTo(p2[0], p2[1]).close();
            dim = BitsUtil.nextSetBit(dims, dim + 1);
        }
        return path.makeElement(svgp);
    }
}

