/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.ArrayListIter;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import org.w3c.dom.Element;

public class SVGPath {
    private StringBuilder buf = new StringBuilder(200);
    private char lastaction = '\u0000';
    public static final char PATH_CLOSE = 'Z';
    public static final char PATH_LINE_TO = 'L';
    public static final char PATH_LINE_TO_RELATIVE = 'l';
    public static final char PATH_MOVE = 'M';
    public static final char PATH_MOVE_RELATIVE = 'm';
    public static final char PATH_HORIZONTAL_LINE_TO = 'H';
    public static final char PATH_HORIZONTAL_LINE_TO_RELATIVE = 'h';
    public static final char PATH_VERTICAL_LINE_TO = 'V';
    public static final char PATH_VERTICAL_LINE_TO_RELATIVE = 'v';
    public static final char PATH_CUBIC_TO = 'C';
    public static final char PATH_CUBIC_TO_RELATIVE = 'c';
    public static final char PATH_SMOOTH_CUBIC_TO = 'S';
    public static final char PATH_SMOOTH_CUBIC_TO_RELATIVE = 's';
    public static final char PATH_QUAD_TO = 'Q';
    public static final char PATH_QUAD_TO_RELATIVE = 'q';
    public static final char PATH_SMOOTH_QUAD_TO = 'T';
    public static final char PATH_SMOOTH_QUAD_TO_RELATIVE = 't';
    public static final char PATH_ARC = 'A';
    public static final char PATH_ARC_RELATIVE = 'a';

    public SVGPath() {
    }

    public SVGPath(double x, double y) {
        this();
        this.moveTo(x, y);
    }

    public SVGPath(double[] xy) {
        this();
        this.moveTo(xy[0], xy[1]);
    }

    public SVGPath(Polygon vectors) {
        this();
        ArrayListIter<double[]> it = vectors.iter();
        while (it.valid()) {
            this.drawTo(it.get());
            it.advance();
        }
        this.close();
    }

    public SVGPath drawTo(double x, double y) {
        return !this.isStarted() ? this.moveTo(x, y) : this.lineTo(x, y);
    }

    public SVGPath drawTo(double[] xy) {
        return !this.isStarted() ? this.moveTo(xy[0], xy[1]) : this.lineTo(xy[0], xy[1]);
    }

    public boolean isStarted() {
        return this.lastaction != '\u0000';
    }

    public SVGPath lineTo(double x, double y) {
        return this.append('L').append(x).append(y);
    }

    public SVGPath lineTo(double[] xy) {
        return this.lineTo(xy[0], xy[1]);
    }

    public SVGPath relativeLineTo(double x, double y) {
        return this.append('l').append(x).append(y);
    }

    public SVGPath relativeLineTo(double[] xy) {
        return this.relativeLineTo(xy[0], xy[1]);
    }

    public SVGPath horizontalLineTo(double x) {
        return this.append('H').append(x);
    }

    public SVGPath relativeHorizontalLineTo(double x) {
        return this.append('h').append(x);
    }

    public SVGPath verticalLineTo(double y) {
        return this.append('V').append(y);
    }

    public SVGPath relativeVerticalLineTo(double y) {
        return this.append('v').append(y);
    }

    public SVGPath moveTo(double x, double y) {
        return this.append('M').append(x).append(y);
    }

    public SVGPath moveTo(double[] xy) {
        return this.moveTo(xy[0], xy[1]);
    }

    public SVGPath relativeMoveTo(double x, double y) {
        return this.append('m').append(x).append(y);
    }

    public SVGPath relativeMoveTo(double[] xy) {
        return this.relativeMoveTo(xy[0], xy[1]);
    }

    public SVGPath cubicTo(double c1x, double c1y, double c2x, double c2y, double x, double y) {
        return this.append('C').append(c1x).append(c1y).append(c2x).append(c2y).append(x).append(y);
    }

    public SVGPath cubicTo(double[] c1xy, double[] c2xy, double[] xy) {
        return this.append('C').append(c1xy[0]).append(c1xy[1]).append(c2xy[0]).append(c2xy[1]).append(xy[0]).append(xy[1]);
    }

    public SVGPath relativeCubicTo(double c1x, double c1y, double c2x, double c2y, double x, double y) {
        return this.append('c').append(c1x).append(c1y).append(c2x).append(c2y).append(x).append(y);
    }

    public SVGPath relativeCubicTo(double[] c1xy, double[] c2xy, double[] xy) {
        return this.append('c').append(c1xy[0]).append(c1xy[1]).append(c2xy[0]).append(c2xy[1]).append(xy[0]).append(xy[1]);
    }

    public SVGPath smoothCubicTo(double c2x, double c2y, double x, double y) {
        return this.append('S').append(c2x).append(c2y).append(x).append(y);
    }

    public SVGPath smoothCubicTo(double[] c2xy, double[] xy) {
        return this.append('S').append(c2xy[0]).append(c2xy[1]).append(xy[0]).append(xy[1]);
    }

    public SVGPath relativeSmoothCubicTo(double c2x, double c2y, double x, double y) {
        return this.append('s').append(c2x).append(c2y).append(x).append(y);
    }

    public SVGPath relativeSmoothCubicTo(double[] c2xy, double[] xy) {
        return this.append('s').append(c2xy[0]).append(c2xy[1]).append(xy[0]).append(xy[1]);
    }

    public SVGPath quadTo(double c1x, double c1y, double x, double y) {
        return this.append('Q').append(c1x).append(c1y).append(x).append(y);
    }

    public SVGPath quadTo(double[] c1xy, double[] xy) {
        return this.append('Q').append(c1xy[0]).append(c1xy[1]).append(xy[0]).append(xy[1]);
    }

    public SVGPath relativeQuadTo(double c1x, double c1y, double x, double y) {
        return this.append('q').append(c1x).append(c1y).append(x).append(y);
    }

    public SVGPath relativeQuadTo(double[] c1xy, double[] xy) {
        return this.append('q').append(c1xy[0]).append(c1xy[1]).append(xy[0]).append(xy[1]);
    }

    public SVGPath smoothQuadTo(double x, double y) {
        return this.append('T').append(x).append(y);
    }

    public SVGPath smoothQuadTo(double[] xy) {
        return this.append('T').append(xy[0]).append(xy[1]);
    }

    public SVGPath relativeSmoothQuadTo(double x, double y) {
        return this.append('t').append(x).append(y);
    }

    public SVGPath relativeSmoothQuadTo(double[] xy) {
        return this.append('t').append(xy[0]).append(xy[1]);
    }

    public SVGPath ellipticalArc(double rx, double ry, double ar, double la, double sp, double x, double y) {
        return this.append('A').append(rx).append(ry).append(ar).append(la).append(sp).append(x).append(y);
    }

    public SVGPath ellipticalArc(double rx, double ry, double ar, double la, double sp, double[] xy) {
        return this.append('A').append(rx).append(ry).append(ar).append(la).append(sp).append(xy[0]).append(xy[1]);
    }

    public SVGPath ellipticalArc(double[] rxy, double ar, double la, double sp, double[] xy) {
        return this.append('A').append(rxy[0]).append(rxy[1]).append(ar).append(la).append(sp).append(xy[0]).append(xy[1]);
    }

    public SVGPath relativeEllipticalArc(double rx, double ry, double ar, double la, double sp, double x, double y) {
        return this.append('a').append(rx).append(ry).append(ar).append(la).append(sp).append(x).append(y);
    }

    public SVGPath relativeEllipticalArc(double rx, double ry, double ar, double la, double sp, double[] xy) {
        return this.append('a').append(rx).append(ry).append(ar).append(la).append(sp).append(xy[0]).append(xy[1]);
    }

    public SVGPath relativeEllipticalArc(double[] rxy, double ar, double la, double sp, double[] xy) {
        return this.append('a').append(rxy[0]).append(rxy[1]).append(ar).append(la).append(sp).append(xy[0]).append(xy[1]);
    }

    private SVGPath append(char action) {
        assert (this.lastaction != '\u0000' || action == 'M') : "Paths must begin with a move to the initial position!";
        if (this.lastaction != action) {
            this.buf.append(action);
            this.lastaction = action;
        }
        return this;
    }

    private SVGPath append(double x) {
        int l;
        if (!Double.isFinite(x)) {
            throw new IllegalArgumentException("Cannot draw an infinite/NaN position.");
        }
        if (x >= 0.0 && (l = this.buf.length()) > 0) {
            char c = this.buf.charAt(l - 1);
            assert (c != 'e' && c != 'E') : "Invalid exponential in path";
            if (c >= '0' && c <= '9') {
                this.buf.append(' ');
            }
        }
        this.buf.append(SVGUtil.FMT.format(x));
        return this;
    }

    public SVGPath close() {
        assert (this.lastaction != '\u0000') : "Paths must begin with a move to the initial position!";
        if (this.lastaction != 'Z') {
            this.buf.append(' ').append('Z');
            this.lastaction = (char)90;
        }
        return this;
    }

    public Element makeElement(SVGPlot plot) {
        Element elem = plot.svgElement("path");
        elem.setAttribute("d", this.buf.toString());
        return elem;
    }

    public Element makeElement(SVGPlot plot, String cssclass) {
        Element elem = plot.svgElement("path", cssclass);
        elem.setAttribute("d", this.buf.toString());
        return elem;
    }

    public String toString() {
        return this.buf.toString();
    }
}

