/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FileUtil;
import de.lmu.ifi.dbs.elki.visualization.batikutil.CloneInlineImages;
import de.lmu.ifi.dbs.elki.visualization.batikutil.ThumbnailTranscoder;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.svg.UpdateRunner;
import de.lmu.ifi.dbs.elki.visualization.svg.UpdateSynchronizer;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGPoint;

public class SVGPlot {
    public static final float DEFAULT_QUALITY = 0.85f;
    public static final String NO_EXPORT_ATTRIBUTE = "noexport";
    private static final DOMImplementation BATIK_DOM;
    private static final String[] BATIK_DOMS;
    private SVGDocument document;
    private Element root;
    private Element defs;
    private Element style;
    private CSSClassManager cssman;
    private HashMap<String, WeakReference<Element>> objWithId = new HashMap();
    private UpdateRunner runner = new UpdateRunner(this);
    private boolean disableInteractions = false;

    public SVGPlot() {
        DOMImplementation domImpl = SVGPlot.getDomImpl();
        DocumentType dt = domImpl.createDocumentType("svg", "-//W3C//DTD SVG 1.0//EN", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
        if (dt.getName() == null) {
            dt = null;
        }
        this.document = (SVGDocument)domImpl.createDocument("http://www.w3.org/2000/svg", "svg", dt);
        this.root = this.document.getDocumentElement();
        this.root.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.defs = this.svgElement("defs");
        this.root.appendChild(this.defs);
        this.style = SVGUtil.makeStyleElement(this.document);
        this.root.appendChild(this.style);
        this.cssman = new CSSClassManager();
    }

    public static DOMImplementation getDomImpl() {
        if (BATIK_DOM == null) {
            throw new AbortException("No usable Apache Batik SVG DOM could be located.");
        }
        return BATIK_DOM;
    }

    public void dispose() {
        this.runner.clear();
    }

    public Element svgElement(String name) {
        return SVGUtil.svgElement(this.document, name);
    }

    public Element svgElement(String name, String cssclass) {
        Element elem = SVGUtil.svgElement(this.document, name);
        if (cssclass != null) {
            elem.setAttribute("class", cssclass);
        }
        return elem;
    }

    public Element svgRect(double x, double y, double w, double h) {
        return SVGUtil.svgRect(this.document, x, y, w, h);
    }

    public Element svgCircle(double cx, double cy, double r) {
        return SVGUtil.svgCircle(this.document, cx, cy, r);
    }

    public Element svgLine(double x1, double y1, double x2, double y2) {
        return SVGUtil.svgLine(this.document, x1, y1, x2, y2);
    }

    public Element svgText(double x, double y, String text) {
        return SVGUtil.svgText(this.document, x, y, text);
    }

    public SVGPoint elementCoordinatesFromEvent(Element tag, Event evt) {
        return SVGUtil.elementCoordinatesFromEvent(this.document, tag, evt);
    }

    public SVGDocument getDocument() {
        return this.document;
    }

    public Element getRoot() {
        return this.root;
    }

    public Element getDefs() {
        return this.defs;
    }

    @Deprecated
    public Element getStyle() {
        return this.style;
    }

    public CSSClassManager getCSSClassManager() {
        return this.cssman;
    }

    public void addCSSClassOrLogError(CSSClass cls) {
        try {
            this.cssman.addClass(cls);
        }
        catch (CSSClassManager.CSSNamingConflict e) {
            LoggingUtil.exception(e);
        }
    }

    public void updateStyleElement() {
        Element newstyle = this.cssman.makeStyleElement(this.document);
        this.style.getParentNode().replaceChild(newstyle, this.style);
        this.style = newstyle;
    }

    public void saveAsSVG(File file) throws IOException, TransformerFactoryConfigurationError, TransformerException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        StreamResult result = new StreamResult(out);
        SVGDocument doc = this.cloneDocument();
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.transform(new DOMSource(doc), result);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }

    protected void transcode(File file, Transcoder transcoder) throws IOException, TranscoderException {
        transcoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING, Boolean.FALSE);
        SVGDocument doc = this.cloneDocument();
        TranscoderInput input = new TranscoderInput(doc);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        TranscoderOutput output = new TranscoderOutput(out);
        transcoder.transcode(input, output);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }

    protected SVGDocument cloneDocument() {
        return (SVGDocument)new CloneInlineImages(){

            @Override
            public Node cloneNode(Document doc, Node eold) {
                Element eeold;
                String vis;
                if (eold instanceof Element && (vis = (eeold = (Element)eold).getAttribute(SVGPlot.NO_EXPORT_ATTRIBUTE)) != null && vis.length() > 0) {
                    return null;
                }
                return super.cloneNode(doc, eold);
            }
        }.cloneDocument(SVGPlot.getDomImpl(), this.document);
    }

    public void saveAsPDF(File file) throws IOException, TranscoderException, ClassNotFoundException {
        try {
            Object t = Class.forName("org.apache.fop.svg.PDFTranscoder").newInstance();
            this.transcode(file, (Transcoder)t);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ClassNotFoundException("Could not instantiate PDF transcoder - is Apache FOP installed?", e);
        }
    }

    public void saveAsPS(File file) throws IOException, TranscoderException, ClassNotFoundException {
        try {
            Object t = Class.forName("org.apache.fop.render.ps.PSTranscoder").newInstance();
            this.transcode(file, (Transcoder)t);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ClassNotFoundException("Could not instantiate PS transcoder - is Apache FOP installed?", e);
        }
    }

    public void saveAsEPS(File file) throws IOException, TranscoderException, ClassNotFoundException {
        try {
            Object t = Class.forName("org.apache.fop.render.ps.EPSTranscoder").newInstance();
            this.transcode(file, (Transcoder)t);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ClassNotFoundException("Could not instantiate EPS transcoder - is Apache FOP installed?", e);
        }
    }

    public void saveAsPNG(File file, int width, int height) throws IOException, TranscoderException {
        PNGTranscoder t = new PNGTranscoder();
        t.addTranscodingHint(PNGTranscoder.KEY_WIDTH, new Float(width));
        t.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, new Float(height));
        this.transcode(file, t);
    }

    public void saveAsJPEG(File file, int width, int height, float quality) throws IOException, TranscoderException {
        JPEGTranscoder t = new JPEGTranscoder();
        t.addTranscodingHint(JPEGTranscoder.KEY_WIDTH, new Float(width));
        t.addTranscodingHint(JPEGTranscoder.KEY_HEIGHT, new Float(height));
        t.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, new Float(quality));
        this.transcode(file, t);
    }

    public void saveAsJPEG(File file, int width, int height) throws IOException, TranscoderException {
        this.saveAsJPEG(file, width, height, 0.85f);
    }

    public void saveAsANY(File file, int width, int height, float quality) throws IOException, TranscoderException, TransformerFactoryConfigurationError, TransformerException, ClassNotFoundException {
        String extension = FileUtil.getFilenameExtension(file);
        if ("svg".equals(extension)) {
            this.saveAsSVG(file);
        } else if ("pdf".equals(extension)) {
            this.saveAsPDF(file);
        } else if ("ps".equals(extension)) {
            this.saveAsPS(file);
        } else if ("eps".equals(extension)) {
            this.saveAsEPS(file);
        } else if ("png".equals(extension)) {
            this.saveAsPNG(file, width, height);
        } else if ("jpg".equals(extension) || "jpeg".equals(extension)) {
            this.saveAsJPEG(file, width, height, quality);
        } else {
            throw new IOException("Unknown file extension: " + extension);
        }
    }

    public BufferedImage makeAWTImage(int width, int height) throws TranscoderException {
        ThumbnailTranscoder t = new ThumbnailTranscoder();
        t.addTranscodingHint(PNGTranscoder.KEY_WIDTH, new Float(width));
        t.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, new Float(height));
        TranscoderInput input = new TranscoderInput(this.document);
        t.transcode(input, null);
        return t.getLastImage();
    }

    public void dumpDebugFile() {
        try {
            File f = File.createTempFile("elki-debug", ".svg");
            f.deleteOnExit();
            this.saveAsSVG(f);
            LoggingUtil.warning("Saved debug file to: " + f.getAbsolutePath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void putIdElement(String id, Element obj) {
        this.objWithId.put(id, new WeakReference<Element>(obj));
    }

    public Element getIdElement(String id) {
        WeakReference<Element> ref = this.objWithId.get(id);
        return ref != null ? (Element)ref.get() : null;
    }

    protected Collection<String> getAllIds() {
        return this.objWithId.keySet();
    }

    public void scheduleUpdate(Runnable runnable) {
        this.runner.invokeLater(runnable);
    }

    public void synchronizeWith(UpdateSynchronizer sync) {
        this.runner.synchronizeWith(sync);
    }

    public void unsynchronizeWith(UpdateSynchronizer sync) {
        this.runner.unsynchronizeWith(sync);
    }

    public boolean getDisableInteractions() {
        return this.disableInteractions;
    }

    public void setDisableInteractions(boolean disable) {
        this.disableInteractions = disable;
    }

    static {
        BATIK_DOMS = new String[]{"org.apache.batik.anim.dom.SVGDOMImplementation", "org.apache.batik.dom.svg.SVGDOMImplementation", "com.sun.org.apache.xerces.internal.dom.DOMImplementationImpl"};
        DOMImplementation dom = null;
        for (String s : BATIK_DOMS) {
            try {
                Class<?> c = Class.forName(s);
                Method m = c.getDeclaredMethod("getDOMImplementation", new Class[0]);
                DOMImplementation ret = (DOMImplementation)DOMImplementation.class.cast(m.invoke(null, new Object[0]));
                if (ret == null) continue;
                dom = ret;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        BATIK_DOM = dom;
    }
}

