/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import java.text.NumberFormat;
import org.w3c.dom.Element;

public class SVGScoreBar {
    protected double val;
    protected double min = 0.0;
    protected double max = 1.0;
    protected boolean reversed = false;
    protected String label = null;
    private NumberFormat format = null;

    public void setFill(double val, double min, double max) {
        this.val = val;
        this.min = min;
        this.max = max;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public void addLabel(String text) {
        this.label = text;
    }

    public void showValues(NumberFormat format) {
        this.format = format;
    }

    public Element build(SVGPlot svgp, double x, double y, double width, double height) {
        Element barchart = svgp.svgElement("g");
        Element bar = svgp.svgRect(x, y, width, height);
        bar.setAttribute("fill", "#a0a0a0");
        bar.setAttribute("stroke", "#a0a0a0");
        bar.setAttribute("stroke-width", String.valueOf(height * 0.01));
        barchart.appendChild(bar);
        if (this.val >= this.min && this.val <= this.max && this.min < this.max) {
            double frame = 0.02 * height;
            double fpos = (this.val - this.min) / (this.max - this.min) * (width - 2.0 * frame);
            Element chart = this.reversed ? svgp.svgRect(x + frame + fpos, y + frame, width - fpos - 2.0 * frame, height - 2.0 * frame) : svgp.svgRect(x + frame, y + frame, fpos, height - 2.0 * frame);
            chart.setAttribute("fill", "#d4e4f1");
            chart.setAttribute("stroke", "#a0a0a0");
            chart.setAttribute("stroke-width", String.valueOf(height * 0.01));
            barchart.appendChild(chart);
        }
        if (this.format != null) {
            String num = Double.isNaN(this.val) ? "NaN" : this.format.format(this.val);
            Element lbl = svgp.svgText(x + 0.05 * width, y + 0.75 * height, num);
            lbl.setAttribute("style", "font-size: " + 0.75 * height + "; font-weight: bold");
            barchart.appendChild(lbl);
        }
        if (this.label != null) {
            Element lbl = svgp.svgText(x + 1.05 * width, y + 0.75 * height, this.label);
            lbl.setAttribute("style", "font-size: " + 0.75 * height + "; font-weight: normal");
            barchart.appendChild(lbl);
        }
        return barchart;
    }
}

