/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import net.jafama.FastMath;
import org.w3c.dom.Element;

public final class SVGSimpleLinearAxis {
    private static final String CSS_AXIS = "axis";
    private static final String CSS_AXIS_TICK = "axis-tick";
    private static final String CSS_AXIS_LABEL = "axis-label";

    private SVGSimpleLinearAxis() {
    }

    private static void setupCSSClasses(Object owner, CSSClassManager manager, StyleLibrary style) throws CSSClassManager.CSSNamingConflict {
        if (!manager.contains(CSS_AXIS)) {
            CSSClass axis = new CSSClass(owner, CSS_AXIS);
            axis.setStatement("stroke", style.getColor(CSS_AXIS));
            axis.setStatement("stroke-width", style.getLineWidth(CSS_AXIS));
            manager.addClass(axis);
        }
        if (!manager.contains(CSS_AXIS_TICK)) {
            CSSClass tick = new CSSClass(owner, CSS_AXIS_TICK);
            tick.setStatement("stroke", style.getColor("axis.tick"));
            tick.setStatement("stroke-width", style.getLineWidth("axis.tick"));
            manager.addClass(tick);
        }
        if (!manager.contains(CSS_AXIS_LABEL)) {
            CSSClass label = new CSSClass(owner, CSS_AXIS_LABEL);
            label.setStatement("fill", style.getTextColor("axis.label"));
            label.setStatement("font-family", style.getFontFamily("axis.label"));
            label.setStatement("font-size", style.getTextSize("axis.label"));
            manager.addClass(label);
        }
    }

    public static void drawAxis(SVGPlot plot, Element parent, LinearScale scale, double x1, double y1, double x2, double y2, LabelStyle labelstyle, StyleLibrary style) throws CSSClassManager.CSSNamingConflict {
        boolean ticks;
        boolean labels;
        assert (parent != null);
        Element line = plot.svgLine(x1, y1, x2, y2);
        SVGUtil.setCSSClass(line, CSS_AXIS);
        parent.appendChild(line);
        double tx = x2 - x1;
        double ty = y2 - y1;
        double tw = ty * 0.01;
        double th = -tx * 0.01;
        switch (labelstyle) {
            case LEFTHAND: 
            case RIGHTHAND: {
                labels = true;
                ticks = true;
                break;
            }
            case NOLABELS: {
                labels = false;
                ticks = true;
                break;
            }
            default: {
                labels = false;
                ticks = false;
            }
        }
        Alignment pos = Alignment.LL;
        if (labels) {
            double angle = FastMath.atan2(ty, tx);
            pos = angle > 2.6 ? (labelstyle == LabelStyle.RIGHTHAND ? Alignment.RC : Alignment.LC) : (angle > 0.5 ? (labelstyle == LabelStyle.RIGHTHAND ? Alignment.RR : Alignment.LL) : (angle > -0.5 ? (labelstyle == LabelStyle.RIGHTHAND ? Alignment.RC : Alignment.LC) : (angle > -2.6 ? (labelstyle == LabelStyle.RIGHTHAND ? Alignment.RL : Alignment.LR) : (labelstyle == LabelStyle.RIGHTHAND ? Alignment.RC : Alignment.LC))));
        }
        double textvoff = style.getTextSize("axis.label") * 0.35;
        if (ticks || labels) {
            double minl;
            int sw = 1;
            int numticks = (int)((scale.getMax() - scale.getMin()) / scale.getRes());
            double tlen = FastMath.sqrt(tx * tx + ty * ty);
            if ((double)sw * tlen / (double)numticks < (minl = 10.0 * style.getLineWidth("axis.tick"))) {
                for (int i = 2; i <= numticks >> 1; ++i) {
                    if (numticks % i != 0 || !((double)i * tlen / (double)numticks >= minl)) continue;
                    sw = i;
                    break;
                }
            }
            if ((double)sw * tlen / (double)numticks < minl) {
                sw = (int)Math.floor(minl * (double)numticks / tlen);
            }
            for (double tick = scale.getMin(); tick <= scale.getMax() + scale.getRes() / 10.0; tick += (double)sw * scale.getRes()) {
                double x = x1 + tx * scale.getScaled(tick);
                double y = y1 + ty * scale.getScaled(tick);
                if (ticks) {
                    Element tickline = plot.svgLine(x - tw, y - th, x + tw, y + th);
                    SVGUtil.setAtt(tickline, "class", CSS_AXIS_TICK);
                    parent.appendChild(tickline);
                }
                if (!labels) continue;
                double tex = x;
                double tey = y;
                switch (pos) {
                    case LL: 
                    case LC: 
                    case LR: {
                        tex = x + tw * 2.5;
                        tey = y + th * 2.5 + textvoff;
                        break;
                    }
                    case RL: 
                    case RC: 
                    case RR: {
                        tex = x - tw * 2.5;
                        tey = y - th * 2.5 + textvoff;
                    }
                }
                Element text = plot.svgText(tex, tey, scale.formatValue(tick));
                text.setAttribute("class", CSS_AXIS_LABEL);
                switch (pos) {
                    case LL: 
                    case RL: {
                        text.setAttribute("text-anchor", "start");
                        break;
                    }
                    case LC: 
                    case RC: {
                        text.setAttribute("text-anchor", "middle");
                        break;
                    }
                    case LR: 
                    case RR: {
                        text.setAttribute("text-anchor", "end");
                    }
                }
                parent.appendChild(text);
            }
        }
        if (labelstyle == LabelStyle.ENDLABEL) {
            Element text = plot.svgText(x1 - tx * 0.02, y1 - ty * 0.02 + textvoff, scale.formatValue(scale.getMin()));
            text.setAttribute("class", CSS_AXIS_LABEL);
            text.setAttribute("text-anchor", "middle");
            parent.appendChild(text);
            text = plot.svgText(x2 + tx * 0.02, y2 + ty * 0.02 + textvoff, scale.formatValue(scale.getMax()));
            text.setAttribute("class", CSS_AXIS_LABEL);
            text.setAttribute("text-anchor", "middle");
            parent.appendChild(text);
        }
        SVGSimpleLinearAxis.setupCSSClasses(plot, plot.getCSSClassManager(), style);
    }

    public static enum LabelStyle {
        LEFTHAND,
        RIGHTHAND,
        NOLABELS,
        NOTHING,
        ENDLABEL;

    }

    private static enum Alignment {
        LL,
        RL,
        LC,
        RC,
        LR,
        RR;

    }
}

