/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.text.html.StyleSheet;
import net.jafama.DoubleWrapper;
import net.jafama.FastMath;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;

public final class SVGUtil {
    public static final NumberFormat FMT = NumberFormat.getInstance(Locale.ROOT);
    public static final String HOURGLASS_PATH = "M.35 .2 L.65 .2 L.65 .3 L.35 .7 L.35 .8 L.65 .8 L.65 .7 L.35 .3 Z";
    public static final String HOURGLASS_STYLE = "stroke: black; stroke-width: .01; fill: grey; opacity: .2";
    public static final String THROBBER_PATH = "M.5,.25 a.25,.25 0 0 1 .1766,.42635 l-.0589 -.0589 a-.1766 -.1766 0 0 0 -.1178,-.2835 z";
    public static final String THROBBER_STYLE = "fill: #3d7fe6; opacity: .2";
    private static final Object2IntOpenHashMap<String> SVG_COLOR_NAMES;
    private static final int NO_VALUE = 1193046;
    private static final StyleSheet colorLookupStylesheet;

    private SVGUtil() {
    }

    public static String fmt(double x) {
        return FMT.format(x);
    }

    public static Element svgElement(Document document, String name) {
        return document.createElementNS("http://www.w3.org/2000/svg", name);
    }

    public static void setAtt(Element el, String name, double d) {
        el.setAttribute(name, SVGUtil.fmt(d));
    }

    public static void setAtt(Element el, String name, int d) {
        el.setAttribute(name, Integer.toString(d));
    }

    public static void setAtt(Element el, String name, String d) {
        el.setAttribute(name, d);
    }

    public static void setStyle(Element el, String d) {
        el.setAttribute("style", d);
    }

    public static void setCSSClass(Element e, String cssclass) {
        SVGUtil.setAtt(e, "class", cssclass);
    }

    public static void addCSSClass(Element e, String cssclass) {
        String[] classes;
        String oldval = e.getAttribute("class");
        if (oldval == null || oldval.length() == 0) {
            SVGUtil.setAtt(e, "class", cssclass);
            return;
        }
        for (String c : classes = oldval.split(" ")) {
            if (!c.equals(cssclass)) continue;
            return;
        }
        SVGUtil.setAtt(e, "class", oldval + " " + cssclass);
    }

    public static void removeCSSClass(Element e, String cssclass) {
        String oldval = e.getAttribute("class");
        if (oldval == null) {
            return;
        }
        String[] classes = oldval.split(" ");
        if (classes.length == 1) {
            if (cssclass.equals(classes[0])) {
                e.removeAttribute("class");
            }
        } else if (classes.length == 2) {
            if (cssclass.equals(classes[0])) {
                if (cssclass.equals(classes[1])) {
                    e.removeAttribute("class");
                } else {
                    e.setAttribute("class", classes[1]);
                }
            } else if (cssclass.equals(classes[1])) {
                e.setAttribute("class", classes[0]);
            }
        } else {
            StringBuilder joined = new StringBuilder();
            for (String c : classes) {
                if (c.equals(cssclass)) continue;
                if (joined.length() > 0) {
                    joined.append(' ');
                }
                joined.append(c);
            }
            e.setAttribute("class", joined.toString());
        }
    }

    public static Element makeStyleElement(Document document) {
        Element style = SVGUtil.svgElement(document, "style");
        style.setAttribute("type", "text/css");
        return style;
    }

    public static Element svgRect(Document document, double x, double y, double w, double h) {
        Element rect = SVGUtil.svgElement(document, "rect");
        SVGUtil.setAtt(rect, "x", x);
        SVGUtil.setAtt(rect, "y", y);
        SVGUtil.setAtt(rect, "width", w);
        SVGUtil.setAtt(rect, "height", h);
        return rect;
    }

    public static Element svgCircle(Document document, double cx, double cy, double r) {
        Element circ = SVGUtil.svgElement(document, "circle");
        SVGUtil.setAtt(circ, "cx", cx);
        SVGUtil.setAtt(circ, "cy", cy);
        SVGUtil.setAtt(circ, "r", r);
        return circ;
    }

    public static Element svgLine(Document document, double x1, double y1, double x2, double y2) {
        Element line = SVGUtil.svgElement(document, "line");
        SVGUtil.setAtt(line, "x1", x1);
        SVGUtil.setAtt(line, "y1", y1);
        SVGUtil.setAtt(line, "x2", x2);
        SVGUtil.setAtt(line, "y2", y2);
        return line;
    }

    public static Element svgText(Document document, double x, double y, String text) {
        Element elem = SVGUtil.svgElement(document, "text");
        SVGUtil.setAtt(elem, "x", x);
        SVGUtil.setAtt(elem, "y", y);
        elem.setTextContent(text);
        return elem;
    }

    public static Element svgWaitIcon(Document document, double x, double y, double w, double h) {
        Element g = SVGUtil.svgElement(document, "g");
        SVGUtil.setAtt(g, "transform", "translate(" + x + " " + y + ") scale(" + w + " " + h + ")");
        Element thro = SVGUtil.svgElement(document, "path");
        SVGUtil.setAtt(thro, "d", THROBBER_PATH);
        SVGUtil.setStyle(thro, THROBBER_STYLE);
        Element anim = SVGUtil.svgElement(document, "animateTransform");
        SVGUtil.setAtt(anim, "attributeName", "transform");
        SVGUtil.setAtt(anim, "attributeType", "XML");
        SVGUtil.setAtt(anim, "type", "rotate");
        SVGUtil.setAtt(anim, "from", "0 .5 .5");
        SVGUtil.setAtt(anim, "to", "360 .5 .5");
        SVGUtil.setAtt(anim, "begin", SVGUtil.fmt(Math.random() * 2.0) + "s");
        SVGUtil.setAtt(anim, "dur", "2s");
        SVGUtil.setAtt(anim, "repeatCount", "indefinite");
        SVGUtil.setAtt(anim, "fill", "freeze");
        thro.appendChild(anim);
        g.appendChild(thro);
        return g;
    }

    public static Color stringToColor(String str) {
        int icol = SVG_COLOR_NAMES.getInt(str.toLowerCase());
        if (icol != 1193046) {
            return new Color(icol, false);
        }
        return colorLookupStylesheet.stringToColor(str);
    }

    public static String colorToString(Color col) {
        return SVGUtil.colorToString(col.getRGB());
    }

    public static String colorToString(int col) {
        char[] buf = new char[]{'#', 'X', 'X', 'X', 'X', 'X', 'X'};
        for (int i = 6; i > 0; --i) {
            int v = col & 0xF;
            buf[i] = (char)(v < 10 ? 48 + v : 97 + v - 10);
            col >>>= 4;
        }
        return new String(buf);
    }

    public static String makeMarginTransform(double owidth, double oheight, double iwidth, double iheight, double lmargin, double tmargin, double rmargin, double bmargin) {
        double swidth = iwidth + lmargin + rmargin;
        double sheight = iheight + tmargin + bmargin;
        double scale = Math.max(swidth / owidth, sheight / oheight);
        double offx = (scale * owidth - swidth) * 0.5 + lmargin;
        double offy = (scale * oheight - sheight) * 0.5 + tmargin;
        return "scale(" + SVGUtil.fmt(1.0 / scale) + ") translate(" + SVGUtil.fmt(offx) + " " + SVGUtil.fmt(offy) + ")";
    }

    public static String makeMarginTransform(double owidth, double oheight, double iwidth, double iheight, double xmargin, double ymargin) {
        return SVGUtil.makeMarginTransform(owidth, oheight, iwidth, iheight, xmargin, ymargin, xmargin, ymargin);
    }

    public static String makeMarginTransform(double owidth, double oheight, double iwidth, double iheight, double margin) {
        return SVGUtil.makeMarginTransform(owidth, oheight, iwidth, iheight, margin, margin, margin, margin);
    }

    public static SVGPoint elementCoordinatesFromEvent(Document doc, Element tag, Event evt) {
        try {
            DOMMouseEvent gnme = (DOMMouseEvent)evt;
            SVGMatrix mat = ((SVGLocatable)((Object)tag)).getScreenCTM();
            SVGMatrix imat = mat.inverse();
            SVGPoint cPt = ((SVGDocument)doc).getRootElement().createSVGPoint();
            cPt.setX(gnme.getClientX());
            cPt.setY(gnme.getClientY());
            return cPt.matrixTransform(imat);
        }
        catch (Exception e) {
            LoggingUtil.warning("Error getting coordinates from SVG event.", e);
            return null;
        }
    }

    public static void removeLastChild(Element tag) {
        Node last = tag.getLastChild();
        if (last != null) {
            tag.removeChild(last);
        }
    }

    public static void removeFromParent(Element elem) {
        if (elem != null && elem.getParentNode() != null) {
            elem.getParentNode().removeChild(elem);
        }
    }

    public static Element svgCircleSegment(SVGPlot svgp, double centerx, double centery, double angleStart, double angleDelta, double innerRadius, double outerRadius) {
        DoubleWrapper tmp = new DoubleWrapper();
        double sin1st = FastMath.sinAndCos(angleStart, tmp);
        double cos1st = tmp.value;
        double sin2nd = FastMath.sinAndCos(angleStart + angleDelta, tmp);
        double cos2nd = tmp.value;
        double inner1stx = centerx + innerRadius * sin1st;
        double inner1sty = centery - innerRadius * cos1st;
        double outer1stx = centerx + outerRadius * sin1st;
        double outer1sty = centery - outerRadius * cos1st;
        double inner2ndx = centerx + innerRadius * sin2nd;
        double inner2ndy = centery - innerRadius * cos2nd;
        double outer2ndx = centerx + outerRadius * sin2nd;
        double outer2ndy = centery - outerRadius * cos2nd;
        double largeArc = angleDelta >= Math.PI ? 1.0 : 0.0;
        SVGPath path = new SVGPath(inner1stx, inner1sty).lineTo(outer1stx, outer1sty).ellipticalArc(outerRadius, outerRadius, 0.0, largeArc, 1.0, outer2ndx, outer2ndy).lineTo(inner2ndx, inner2ndy);
        if (innerRadius > 0.0) {
            path.ellipticalArc(innerRadius, innerRadius, 0.0, largeArc, 0.0, inner1stx, inner1sty);
        }
        return path.makeElement(svgp);
    }

    static {
        FMT.setMaximumFractionDigits(10);
        FMT.setGroupingUsed(false);
        SVG_COLOR_NAMES = new Object2IntOpenHashMap(90);
        SVG_COLOR_NAMES.defaultReturnValue(1193046);
        SVG_COLOR_NAMES.put("aliceblue", -984833);
        SVG_COLOR_NAMES.put("antiquewhite", -332841);
        SVG_COLOR_NAMES.put("aqua", -16711681);
        SVG_COLOR_NAMES.put("aquamarine", -8388652);
        SVG_COLOR_NAMES.put("azure", -983041);
        SVG_COLOR_NAMES.put("beige", -657956);
        SVG_COLOR_NAMES.put("bisque", -6972);
        SVG_COLOR_NAMES.put("black", -16777216);
        SVG_COLOR_NAMES.put("blanchedalmond", -5171);
        SVG_COLOR_NAMES.put("blue", -16776961);
        SVG_COLOR_NAMES.put("blueviolet", -7722014);
        SVG_COLOR_NAMES.put("brown", -5952982);
        SVG_COLOR_NAMES.put("burlywood", -2180985);
        SVG_COLOR_NAMES.put("cadetblue", -10510688);
        SVG_COLOR_NAMES.put("chartreuse", -8388864);
        SVG_COLOR_NAMES.put("chocolate", -2987746);
        SVG_COLOR_NAMES.put("coral", -32944);
        SVG_COLOR_NAMES.put("cornflowerblue", -10185235);
        SVG_COLOR_NAMES.put("cornsilk", -1828);
        SVG_COLOR_NAMES.put("crimson", -2354116);
        SVG_COLOR_NAMES.put("cyan", -16711681);
        SVG_COLOR_NAMES.put("darkblue", -16777077);
        SVG_COLOR_NAMES.put("darkcyan", -16741493);
        SVG_COLOR_NAMES.put("darkgoldenrod", -4684277);
        SVG_COLOR_NAMES.put("darkgray", -5658199);
        SVG_COLOR_NAMES.put("darkgreen", -16751616);
        SVG_COLOR_NAMES.put("darkgrey", -5658199);
        SVG_COLOR_NAMES.put("darkkhaki", -4343957);
        SVG_COLOR_NAMES.put("darkmagenta", -7667573);
        SVG_COLOR_NAMES.put("darkolivegreen", -11179217);
        SVG_COLOR_NAMES.put("darkorange", -29696);
        SVG_COLOR_NAMES.put("darkorchid", -6737204);
        SVG_COLOR_NAMES.put("darkred", -7667712);
        SVG_COLOR_NAMES.put("darksalmon", -1468806);
        SVG_COLOR_NAMES.put("darkseagreen", -7357297);
        SVG_COLOR_NAMES.put("darkslateblue", -12042869);
        SVG_COLOR_NAMES.put("darkslategray", -13676721);
        SVG_COLOR_NAMES.put("darkslategrey", -13676721);
        SVG_COLOR_NAMES.put("darkturquoise", -16724271);
        SVG_COLOR_NAMES.put("darkviolet", -7077677);
        SVG_COLOR_NAMES.put("deeppink", -60269);
        SVG_COLOR_NAMES.put("deepskyblue", -16728065);
        SVG_COLOR_NAMES.put("dimgray", -9868951);
        SVG_COLOR_NAMES.put("dimgrey", -9868951);
        SVG_COLOR_NAMES.put("dodgerblue", -14774017);
        SVG_COLOR_NAMES.put("firebrick", -5103070);
        SVG_COLOR_NAMES.put("floralwhite", -1296);
        SVG_COLOR_NAMES.put("forestgreen", -14513374);
        SVG_COLOR_NAMES.put("fuchsia", -65281);
        SVG_COLOR_NAMES.put("gainsboro", -2302756);
        SVG_COLOR_NAMES.put("ghostwhite", -460545);
        SVG_COLOR_NAMES.put("gold", -10496);
        SVG_COLOR_NAMES.put("goldenrod", -2448096);
        SVG_COLOR_NAMES.put("gray", -8355712);
        SVG_COLOR_NAMES.put("grey", -8355712);
        SVG_COLOR_NAMES.put("green", -16744448);
        SVG_COLOR_NAMES.put("greenyellow", -5374161);
        SVG_COLOR_NAMES.put("honeydew", -983056);
        SVG_COLOR_NAMES.put("hotpink", -38476);
        SVG_COLOR_NAMES.put("indianred", -3318692);
        SVG_COLOR_NAMES.put("indigo", -11861886);
        SVG_COLOR_NAMES.put("ivory", -16);
        SVG_COLOR_NAMES.put("khaki", -989556);
        SVG_COLOR_NAMES.put("lavender", -1644806);
        SVG_COLOR_NAMES.put("lavenderblush", -3851);
        SVG_COLOR_NAMES.put("lawngreen", -8586240);
        SVG_COLOR_NAMES.put("lemonchiffon", -1331);
        SVG_COLOR_NAMES.put("lightblue", -5383962);
        SVG_COLOR_NAMES.put("lightcoral", -1015680);
        SVG_COLOR_NAMES.put("lightcyan", -2031617);
        SVG_COLOR_NAMES.put("lightgoldenrodyellow", -329006);
        SVG_COLOR_NAMES.put("lightgray", -2894893);
        SVG_COLOR_NAMES.put("lightgreen", -7278960);
        SVG_COLOR_NAMES.put("lightgrey", -2894893);
        SVG_COLOR_NAMES.put("lightpink", -18751);
        SVG_COLOR_NAMES.put("lightsalmon", -24454);
        SVG_COLOR_NAMES.put("lightseagreen", -14634326);
        SVG_COLOR_NAMES.put("lightskyblue", -7876870);
        SVG_COLOR_NAMES.put("lightslategray", -8943463);
        SVG_COLOR_NAMES.put("lightslategrey", -8943463);
        SVG_COLOR_NAMES.put("lightsteelblue", -5192482);
        SVG_COLOR_NAMES.put("lightyellow", -32);
        SVG_COLOR_NAMES.put("lime", -16711936);
        SVG_COLOR_NAMES.put("limegreen", -13447886);
        SVG_COLOR_NAMES.put("linen", -331546);
        SVG_COLOR_NAMES.put("magenta", -65281);
        SVG_COLOR_NAMES.put("maroon", -8388608);
        SVG_COLOR_NAMES.put("mediumaquamarine", -10039894);
        SVG_COLOR_NAMES.put("mediumblue", -16777011);
        SVG_COLOR_NAMES.put("mediumorchid", -4565549);
        SVG_COLOR_NAMES.put("mediumpurple", -7114533);
        SVG_COLOR_NAMES.put("mediumseagreen", -12799119);
        SVG_COLOR_NAMES.put("mediumslateblue", -8689426);
        SVG_COLOR_NAMES.put("mediumspringgreen", -16713062);
        SVG_COLOR_NAMES.put("mediumturquoise", -12004916);
        SVG_COLOR_NAMES.put("mediumvioletred", -3730043);
        SVG_COLOR_NAMES.put("midnightblue", -15132304);
        SVG_COLOR_NAMES.put("mintcream", -655366);
        SVG_COLOR_NAMES.put("mistyrose", -6943);
        SVG_COLOR_NAMES.put("moccasin", -6987);
        SVG_COLOR_NAMES.put("navajowhite", -8531);
        SVG_COLOR_NAMES.put("navy", -16777088);
        SVG_COLOR_NAMES.put("oldlace", -133658);
        SVG_COLOR_NAMES.put("olive", -8355840);
        SVG_COLOR_NAMES.put("olivedrab", -9728477);
        SVG_COLOR_NAMES.put("orange", -23296);
        SVG_COLOR_NAMES.put("orangered", -47872);
        SVG_COLOR_NAMES.put("orchid", -2461482);
        SVG_COLOR_NAMES.put("palegoldenrod", -1120086);
        SVG_COLOR_NAMES.put("palegreen", -6751336);
        SVG_COLOR_NAMES.put("paleturquoise", -5247250);
        SVG_COLOR_NAMES.put("palevioletred", -2396013);
        SVG_COLOR_NAMES.put("papayawhip", -4139);
        SVG_COLOR_NAMES.put("peachpuff", -9543);
        SVG_COLOR_NAMES.put("peru", -3308225);
        SVG_COLOR_NAMES.put("pink", -16181);
        SVG_COLOR_NAMES.put("plum", -2252579);
        SVG_COLOR_NAMES.put("powderblue", -5185306);
        SVG_COLOR_NAMES.put("purple", -8388480);
        SVG_COLOR_NAMES.put("red", -65536);
        SVG_COLOR_NAMES.put("rosybrown", -4419697);
        SVG_COLOR_NAMES.put("royalblue", -12490271);
        SVG_COLOR_NAMES.put("saddlebrown", -7650029);
        SVG_COLOR_NAMES.put("salmon", -360334);
        SVG_COLOR_NAMES.put("sandybrown", -744352);
        SVG_COLOR_NAMES.put("seagreen", -13726889);
        SVG_COLOR_NAMES.put("seashell", -2578);
        SVG_COLOR_NAMES.put("sienna", -6270419);
        SVG_COLOR_NAMES.put("silver", -4144960);
        SVG_COLOR_NAMES.put("skyblue", -7876885);
        SVG_COLOR_NAMES.put("slateblue", -9807155);
        SVG_COLOR_NAMES.put("slategray", -9404272);
        SVG_COLOR_NAMES.put("slategrey", -9404272);
        SVG_COLOR_NAMES.put("snow", -1286);
        SVG_COLOR_NAMES.put("springgreen", -16711809);
        SVG_COLOR_NAMES.put("steelblue", -12156236);
        SVG_COLOR_NAMES.put("tan", -2968436);
        SVG_COLOR_NAMES.put("teal", -16744320);
        SVG_COLOR_NAMES.put("thistle", -2572328);
        SVG_COLOR_NAMES.put("tomato", -40121);
        SVG_COLOR_NAMES.put("turquoise", -12525360);
        SVG_COLOR_NAMES.put("violet", -1146130);
        SVG_COLOR_NAMES.put("wheat", -663885);
        SVG_COLOR_NAMES.put("white", -1);
        SVG_COLOR_NAMES.put("whitesmoke", -657931);
        SVG_COLOR_NAMES.put("yellow", -256);
        SVG_COLOR_NAMES.put("yellowgreen", -6632142);
        SVG_COLOR_NAMES.put("transparent", -1);
        colorLookupStylesheet = new StyleSheet();
    }
}

