/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.svg.UpdateSynchronizer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class UpdateRunner {
    private Object sync;
    private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();
    private UpdateSynchronizer synchronizer = null;

    protected UpdateRunner(Object sync) {
        this.sync = sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable r) {
        this.queue.add(r);
        UpdateRunner updateRunner = this;
        synchronized (updateRunner) {
            if (this.synchronizer == null) {
                this.runQueue();
            } else {
                this.synchronizer.activate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runQueue() {
        Object object = this.sync;
        synchronized (object) {
            while (!this.queue.isEmpty()) {
                Runnable r = this.queue.poll();
                if (r != null) {
                    try {
                        r.run();
                    }
                    catch (Exception e) {
                        LoggingUtil.exception(e);
                    }
                    continue;
                }
                LoggingUtil.warning("Tried to run a 'null' Object.");
            }
            return;
        }
    }

    public synchronized void clear() {
        this.queue.clear();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public synchronized void synchronizeWith(UpdateSynchronizer newsync) {
        if (this.synchronizer == newsync) {
            LoggingUtil.warning("Double-synced to the same plot!", new Throwable());
            return;
        }
        if (this.synchronizer != null) {
            LoggingUtil.warning("Attempting to synchronize to more than one synchronizer.");
            return;
        }
        this.synchronizer = newsync;
        newsync.addUpdateRunner(this);
    }

    public synchronized void unsynchronizeWith(UpdateSynchronizer oldsync) {
        if (this.synchronizer == null) {
            LoggingUtil.warning("Warning: was not synchronized.");
            return;
        }
        if (this.synchronizer != oldsync) {
            LoggingUtil.warning("Warning: was synchronized differently!");
            return;
        }
        this.synchronizer = null;
        this.runQueue();
    }
}

