/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.math.geometry.SweepHullDelaunay2D;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import java.util.List;

public final class VoronoiDraw {
    private VoronoiDraw() {
    }

    public static SVGPath drawDelaunay(Projection2D proj, List<SweepHullDelaunay2D.Triangle> delaunay, List<double[]> means) {
        SVGPath path = new SVGPath();
        for (SweepHullDelaunay2D.Triangle del : delaunay) {
            path.moveTo(proj.fastProjectDataToRenderSpace(means.get(del.a)));
            path.drawTo(proj.fastProjectDataToRenderSpace(means.get(del.b)));
            path.drawTo(proj.fastProjectDataToRenderSpace(means.get(del.c)));
            path.close();
        }
        return path;
    }

    public static SVGPath drawVoronoi(Projection2D proj, List<SweepHullDelaunay2D.Triangle> delaunay, List<double[]> means) {
        SVGPath path = new SVGPath();
        CanvasSize viewport = proj.estimateViewport();
        for (int i = 0; i < delaunay.size(); ++i) {
            double[] dir;
            double[] dirv;
            double[] p2;
            double[] p1;
            SweepHullDelaunay2D.Triangle oth;
            SweepHullDelaunay2D.Triangle del = delaunay.get(i);
            double[] projcx = proj.fastProjectDataToRenderSpace(del.m);
            if (del.ab > i) {
                oth = delaunay.get(del.ab);
                p1 = (double[])projcx.clone();
                if (viewport.clipToMargin(p1, p2 = proj.fastProjectDataToRenderSpace(oth.m))) {
                    path.moveTo(p1);
                    path.drawTo(p2);
                }
            } else if (del.ab < 0) {
                dirv = VMath.minus(means.get(del.a), means.get(del.b));
                VMath.rotate90Equals(dirv);
                dir = proj.fastProjectRelativeDataToRenderSpace(dirv);
                double factor = viewport.continueToMargin(projcx, dir);
                if (factor > 0.0) {
                    path.moveTo(projcx);
                    path.relativeLineTo(factor * dir[0], factor * dir[1]);
                }
            }
            if (del.bc > i) {
                oth = delaunay.get(del.bc);
                p1 = (double[])projcx.clone();
                if (viewport.clipToMargin(p1, p2 = proj.fastProjectDataToRenderSpace(oth.m))) {
                    path.moveTo(p1);
                    path.drawTo(p2);
                }
            } else if (del.bc < 0) {
                dirv = VMath.minus(means.get(del.b), means.get(del.c));
                VMath.rotate90Equals(dirv);
                dir = proj.fastProjectRelativeDataToRenderSpace(dirv);
                double factor = viewport.continueToMargin(projcx, dir);
                if (factor > 0.0) {
                    path.moveTo(projcx);
                    path.relativeLineTo(factor * dir[0], factor * dir[1]);
                }
            }
            if (del.ca > i) {
                oth = delaunay.get(del.ca);
                double[] projca = proj.fastProjectDataToRenderSpace(oth.m);
                if (!viewport.clipToMargin(projcx, projca)) continue;
                path.moveTo(projcx);
                path.drawTo(projca);
                continue;
            }
            if (del.ca >= 0) continue;
            dirv = VMath.minus(means.get(del.c), means.get(del.a));
            VMath.rotate90Equals(dirv);
            dir = proj.fastProjectRelativeDataToRenderSpace(dirv);
            double factor = viewport.continueToMargin(projcx, dir);
            if (!(factor > 0.0)) continue;
            path.moveTo(projcx);
            path.relativeLineTo(factor * dir[0], factor * dir[1]);
        }
        return path;
    }

    public static SVGPath drawFakeVoronoi(Projection2D proj, List<double[]> means) {
        CanvasSize viewport = proj.estimateViewport();
        SVGPath path = new SVGPath();
        double[] dirv = VMath.minus(means.get(1), means.get(0));
        VMath.rotate90Equals(dirv);
        double[] dir = proj.fastProjectRelativeDataToRenderSpace(dirv);
        double[] mean = VMath.plus(means.get(0), means.get(1));
        VMath.timesEquals(mean, 0.5);
        double[] projmean = proj.fastProjectDataToRenderSpace(mean);
        double factor = viewport.continueToMargin(projmean, dir);
        path.moveTo(projmean[0] + factor * dir[0], projmean[1] + factor * dir[1]);
        dir[0] = dir[0] * -1.0;
        dir[1] = dir[1] * -1.0;
        factor = viewport.continueToMargin(projmean, dir);
        path.drawTo(projmean[0] + factor * dir[0], projmean[1] + factor * dir[1]);
        return path;
    }
}

