/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreEvent;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.result.SelectionResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import org.w3c.dom.Element;

public abstract class AbstractVisualization
implements Visualization,
ResultListener,
VisualizationListener,
DataStoreListener {
    protected final VisualizationTask task;
    protected final VisualizerContext context;
    protected final VisualizationPlot svgp;
    protected Element layer;
    private double width;
    private double height;

    public AbstractVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height) {
        this.task = task;
        this.context = context;
        this.svgp = plot;
        this.width = width;
        this.height = height;
        this.layer = null;
    }

    protected void addListeners() {
        this.context.addResultListener(this);
        this.context.addVisualizationListener(this);
        if (this.task.has(VisualizationTask.UpdateFlag.ON_DATA)) {
            this.context.addDataStoreListener(this);
        }
    }

    @Override
    public void destroy() {
        this.context.removeResultListener(this);
        this.context.removeVisualizationListener(this);
        this.context.removeDataStoreListener(this);
    }

    @Override
    public Element getLayer() {
        if (this.layer == null) {
            this.incrementalRedraw();
        }
        return this.layer;
    }

    protected double getWidth() {
        return this.width;
    }

    protected double getHeight() {
        return this.height;
    }

    @Override
    public void incrementalRedraw() {
        if (this.layer != null) {
            while (this.layer.hasChildNodes()) {
                this.layer.removeChild(this.layer.getLastChild());
            }
        }
        this.fullRedraw();
    }

    @Override
    public abstract void fullRedraw();

    @Override
    public void resultAdded(Result child, Result parent) {
    }

    @Override
    public void resultChanged(Result current) {
        if (this.task.getResult() == current || this.task.has(VisualizationTask.UpdateFlag.ON_SELECTION) && current instanceof SelectionResult || this.task.has(VisualizationTask.UpdateFlag.ON_SAMPLE) && current instanceof SamplingResult) {
            this.svgp.requestRedraw(this.task, this);
            return;
        }
    }

    @Override
    public void resultRemoved(Result child, Result parent) {
    }

    @Override
    public void visualizationChanged(VisualizationItem item) {
        if (this.task == item || this.task.getResult() == item || this.task.has(VisualizationTask.UpdateFlag.ON_STYLEPOLICY) && item instanceof StylingPolicy) {
            this.svgp.requestRedraw(this.task, this);
            return;
        }
    }

    @Override
    public void contentChanged(DataStoreEvent e) {
        this.svgp.requestRedraw(this.task, this);
    }
}

