/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.VisualizationProcessor;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.thumbs.ThumbnailVisualization;

public interface VisFactory
extends VisualizationProcessor {
    @Override
    public void processNewResult(VisualizerContext var1, Object var2);

    public Visualization makeVisualization(VisualizerContext var1, VisualizationTask var2, VisualizationPlot var3, double var4, double var6, Projection var8);

    default public boolean allowThumbnails(VisualizationTask task) {
        return true;
    }

    default public Visualization makeVisualizationOrThumbnail(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj, int thumbsize) {
        if (width <= 0.0 || height <= 0.0) {
            LoggingUtil.warning("Cannot generate visualization of 0 size.", new Throwable());
            return null;
        }
        if (this.allowThumbnails(task)) {
            return new ThumbnailVisualization(context, this, task, plot, width, height, proj, thumbsize);
        }
        return this.makeVisualization(context, task, plot, width, height, proj);
    }
}

