/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.actions;

import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationMenuAction;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;

public class ClusterStyleAction
implements VisFactory {
    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(Clustering.class).forEach(c -> {
            if (VisualizationTree.findVis(context, c).filter(SetStyleAction.class).valid()) {
                return;
            }
            context.addVis(c, new SetStyleAction((Clustering)c, context));
        });
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        throw new AbortException("Should never be called.");
    }

    private static final class SetStyleAction
    implements VisualizationMenuAction {
        private final Clustering<?> c;
        private final VisualizerContext context;

        private SetStyleAction(Clustering<?> c, VisualizerContext context) {
            this.c = c;
            this.context = context;
        }

        @Override
        public void activate() {
            this.context.setStylingPolicy(new ClusterStylingPolicy(this.c, this.context.getStyleLibrary()));
        }

        @Override
        public String getMenuName() {
            return "Use as Styling Policy";
        }

        @Override
        public boolean enabled() {
            StylingPolicy sp = this.context.getStylingPolicy();
            return !(sp instanceof ClusterStylingPolicy) || ((ClusterStylingPolicy)sp).getClustering() != this.c;
        }
    }
}

