/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.histogram;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.ObjHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.HistogramProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.histogram.AbstractHistogramVisualization;
import java.util.Arrays;
import org.w3c.dom.Element;

public class ColoredHistogramVisualizer
implements VisFactory {
    private static final String CNAME = "Histograms";
    protected Parameterizer settings;
    private static final int DEFAULT_BINS = 80;

    public ColoredHistogramVisualizer(Parameterizer settings) {
        this.settings = settings;
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(HistogramProjector.class).forEach(p -> context.addVis(p, new VisualizationTask(this, CNAME, p, p.getRelation()).level(100).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SAMPLE).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY)));
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID STYLE_CURVES_ID = new OptionID("projhistogram.curves", "Use curves instead of the stacked histogram style.");
        public static final OptionID HISTOGRAM_BINS_ID = new OptionID("projhistogram.bins", "Number of bins in the distribution histogram");
        protected boolean curves = false;
        protected int bins = 80;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter binsP;
            super.makeOptions(config);
            Flag curvesF = new Flag(STYLE_CURVES_ID);
            if (config.grab(curvesF)) {
                this.curves = curvesF.isTrue();
            }
            if (config.grab(binsP = (IntParameter)new IntParameter(HISTOGRAM_BINS_ID, 80).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT))) {
                this.bins = binsP.intValue();
            }
        }

        @Override
        protected ColoredHistogramVisualizer makeInstance() {
            return new ColoredHistogramVisualizer(this);
        }
    }

    public class Instance<NV extends NumberVector>
    extends AbstractHistogramVisualization {
        public static final String BIN = "bin";
        private Relation<NV> relation;
        private SamplingResult sample;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.relation = task.getRelation();
            this.sample = SamplingResult.getSamplingResult(this.relation);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            Iter iter;
            StyleLibrary style = this.context.getStyleLibrary();
            double margin = style.getSize("margin");
            this.layer = SVGUtil.svgElement(this.svgp.getDocument(), "g");
            double xsize = 100.0 * this.getWidth() / this.getHeight();
            double ysize = 100.0;
            String transform = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), xsize, ysize, margin);
            SVGUtil.setAtt(this.layer, "transform", transform);
            StylingPolicy spol = this.context.getStylingPolicy();
            ClassStylingPolicy cspol = spol instanceof ClassStylingPolicy ? (ClassStylingPolicy)spol : null;
            this.setupCSS(this.svgp, cspol != null ? cspol.getMaxStyle() : 0);
            int off = cspol != null ? cspol.getMinStyle() : 0;
            int numc = cspol != null ? cspol.getMaxStyle() - cspol.getMinStyle() : 0;
            DoubleMinMax minmax = new DoubleMinMax();
            double frac = 1.0 / (double)this.relation.size();
            int cols = numc + 2;
            ObjHistogram<double[]> histogram = new ObjHistogram<double[]>(ColoredHistogramVisualizer.this.settings.bins, 0.0, 1.0, () -> new double[cols]);
            if (cspol != null) {
                iter = this.sample.getSample().iter();
                while (iter.valid()) {
                    try {
                        double[] row = histogram.get(this.proj.fastProjectDataToRenderSpace((NumberVector)this.relation.get((DBIDRef)((Object)iter))) * 0.01 + 0.5);
                        row[0] = row[0] + frac;
                        int n = cspol.getStyleForDBID((DBIDRef)((Object)iter)) - off + 2;
                        row[n] = row[n] + frac;
                    }
                    catch (ObjectNotFoundException row) {
                        // empty catch block
                    }
                    iter.advance();
                }
            } else {
                DBIDIter iditer = this.relation.iterDBIDs();
                while (iditer.valid()) {
                    double[] dArray = histogram.get(this.proj.fastProjectDataToRenderSpace((NumberVector)this.relation.get(iditer)) * 0.01 + 0.5);
                    dArray[0] = dArray[0] + frac;
                    iditer.advance();
                }
            }
            iter = histogram.iter();
            while (((AbstractStaticHistogram.Iter)iter).valid()) {
                for (double val : (double[])((ObjHistogram.Iter)iter).getValue()) {
                    minmax.put(val);
                }
                ((AbstractStaticHistogram.Iter)iter).advance();
            }
            LinearScale yscale = new LinearScale(0.0, minmax.getMax());
            try {
                SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, yscale, 0.0, ysize, 0.0, 0.0, SVGSimpleLinearAxis.LabelStyle.LEFTHAND, style);
                int dimensionality = RelationUtil.dimensionality(this.relation);
                double[] vec = new double[dimensionality];
                double orig = this.proj.fastProjectScaledToRender(vec);
                for (int d = 0; d < dimensionality; ++d) {
                    Arrays.fill(vec, 0.0);
                    vec[d] = 1.0;
                    double ax = this.proj.fastProjectScaledToRender(vec);
                    if (!(ax < orig) && !(ax > orig)) continue;
                    double left = (orig / 100.0 + 0.5) * xsize;
                    double right = (ax / 100.0 + 0.5) * xsize;
                    SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, this.proj.getScale(d), left, ysize, right, ysize, SVGSimpleLinearAxis.LabelStyle.RIGHTHAND, style);
                }
            }
            catch (CSSClassManager.CSSNamingConflict e) {
                LoggingUtil.exception("CSS class exception in axis class.", e);
            }
            if (!ColoredHistogramVisualizer.this.settings.curves) {
                ObjHistogram.Iter iter2 = histogram.iter();
                while (iter2.valid()) {
                    int start;
                    double lpos = iter2.getLeft();
                    double rpos = iter2.getRight();
                    double stack = 0.0;
                    for (int key = start = numc > 0 ? 1 : 0; key < cols; ++key) {
                        double val = yscale.getScaled(((double[])iter2.getValue())[key]);
                        Element row = SVGUtil.svgRect(this.svgp.getDocument(), xsize * lpos, ysize * (1.0 - (val + stack)), xsize * (rpos - lpos), ysize * val);
                        stack += val;
                        SVGUtil.addCSSClass(row, BIN + (off + key - 1 - start));
                        this.layer.appendChild(row);
                    }
                    iter2.advance();
                }
            } else {
                double left;
                double right = left = histogram.getCoverMinimum();
                SVGPath[] paths = new SVGPath[cols];
                double[] lasty = new double[cols];
                for (int i = 0; i < cols; ++i) {
                    paths[i] = new SVGPath(xsize * left, ysize * 1.0);
                    lasty[i] = 0.0;
                }
                ObjHistogram.Iter iter3 = histogram.iter();
                while (iter3.valid()) {
                    left = iter3.getLeft();
                    right = iter3.getRight();
                    for (int i = 0; i < cols; ++i) {
                        double val = yscale.getScaled(((double[])iter3.getValue())[i]);
                        if (!(lasty[i] > val) && !(lasty[i] < val)) continue;
                        paths[i].lineTo(xsize * left, ysize * (1.0 - lasty[i]));
                        paths[i].lineTo(xsize * left, ysize * (1.0 - val));
                        paths[i].lineTo(xsize * right, ysize * (1.0 - val));
                        lasty[i] = val;
                    }
                    iter3.advance();
                }
                for (int i = 0; i < cols; ++i) {
                    if (lasty[i] != 0.0) {
                        paths[i].lineTo(xsize * right, ysize * (1.0 - lasty[i]));
                    }
                    paths[i].lineTo(xsize * right, ysize * 1.0);
                    this.layer.appendChild(paths[i].makeElement(this.svgp, BIN + (off + i - 1)));
                }
            }
            this.svgp.updateStyleElement();
        }

        private void setupCSS(SVGPlot svgp, int numc) {
            StyleLibrary style = this.context.getStyleLibrary();
            ColorLibrary colors = style.getColorSet("plot");
            CSSClass allInOne = new CSSClass(svgp, "bin-1");
            if (!ColoredHistogramVisualizer.this.settings.curves) {
                allInOne.setStatement("fill", "black");
                allInOne.setStatement("fill-opacity", 1.0);
            } else {
                allInOne.setStatement("stroke", "black");
                allInOne.setStatement("stroke-width", style.getLineWidth("plot"));
                allInOne.setStatement("fill", "none");
            }
            svgp.addCSSClassOrLogError(allInOne);
            for (int clusterID = 0; clusterID < numc; ++clusterID) {
                CSSClass bin = new CSSClass(svgp, BIN + clusterID);
                if (!ColoredHistogramVisualizer.this.settings.curves) {
                    bin.setStatement("fill", colors.getColor(clusterID));
                } else {
                    bin.setStatement("stroke", colors.getColor(clusterID));
                    bin.setStatement("stroke-width", style.getLineWidth("plot"));
                    bin.setStatement("fill", "none");
                }
                svgp.addCSSClassOrLogError(bin);
            }
        }
    }
}

