/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.optics;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.OPTICSProjection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;

public abstract class AbstractOPTICSVisualization
extends AbstractVisualization {
    protected final OPTICSProjection optics;
    protected double plotwidth;
    protected double plotheight;

    public AbstractOPTICSVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        super(context, task, plot, width, height);
        this.optics = (OPTICSProjection)proj;
    }

    protected void makeLayerElement() {
        this.plotwidth = 100.0;
        this.plotheight = 100.0 / this.optics.getOPTICSPlot(this.context).getRatio();
        double margin = this.context.getStyleLibrary().getSize("margin");
        this.layer = SVGUtil.svgElement(this.svgp.getDocument(), "g");
        String transform = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), this.plotwidth, this.plotheight, margin * 0.5, margin * 0.5, margin * 1.5, margin * 0.5);
        SVGUtil.setAtt(this.layer, "transform", transform);
    }

    protected ClusterOrder getClusterOrder() {
        return this.optics.getResult();
    }
}

