/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.optics;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.OPTICSModel;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.OPTICSProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.optics.AbstractOPTICSVisualization;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class OPTICSClusterVisualization
implements VisFactory {
    private static final Logging LOG = Logging.getLogger(OPTICSClusterVisualization.class);
    private static final String NAME = "OPTICS Cluster Ranges";

    @Override
    public void processNewResult(VisualizerContext context, Object result) {
        VisualizationTree.findVis(context, result).filter(OPTICSProjector.class).forEach(p -> {
            VisualizationTree.findNewResults(context, p.getResult()).filter(Clustering.class).forEach(clus -> {
                if (clus.getToplevelClusters().size() == 0) {
                    return;
                }
                try {
                    Cluster firstcluster = clus.getToplevelClusters().iterator().next();
                    if (firstcluster.getModel() instanceof OPTICSModel) {
                        context.addVis(p, new VisualizationTask(this, NAME, clus, null).level(100));
                    }
                }
                catch (Exception e) {
                    LOG.warning("Clustering with no cluster detected.", e);
                }
            });
            context.getHierarchy().iterAncestors(p.getResult()).filter(Clustering.class).forEach(clus -> {
                if (clus.getToplevelClusters().size() == 0) {
                    return;
                }
                try {
                    Cluster firstcluster = clus.getToplevelClusters().iterator().next();
                    if (firstcluster.getModel() instanceof OPTICSModel) {
                        context.addVis(p, new VisualizationTask(this, NAME, clus, null).level(100));
                    }
                }
                catch (Exception e) {
                    LOG.warning("Clustering with no cluster detected.", e);
                }
            });
        });
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }

    public class Instance
    extends AbstractOPTICSVisualization {
        protected static final String CSS_BRACKET = "opticsBracket";
        Clustering<OPTICSModel> clus;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.clus = (Clustering)task.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.makeLayerElement();
            this.addCSSClasses();
            ColorLibrary colors = this.context.getStyleLibrary().getColorSet("plot");
            HashMap colormap = new HashMap();
            int cnum = 0;
            for (Cluster<OPTICSModel> c : this.clus.getAllClusters()) {
                colormap.put(c, colors.getColor(cnum));
                ++cnum;
            }
            this.drawClusters(this.clus, this.clus.iterToplevelClusters(), 1, colormap);
        }

        private void drawClusters(Clustering<OPTICSModel> clustering, It<Cluster<OPTICSModel>> clusters, int depth, Map<Cluster<?>, String> colormap) {
            double scale = 100.0;
            while (clusters.valid()) {
                Cluster<OPTICSModel> cluster = clusters.get();
                try {
                    OPTICSModel model = cluster.getModel();
                    double x1 = this.plotwidth * (((double)model.getStartIndex() + 0.25) / (double)this.optics.getResult().size());
                    double x2 = this.plotwidth * (((double)model.getEndIndex() + 0.75) / (double)this.optics.getResult().size());
                    double y = this.plotheight + (double)depth * 100.0 * 0.01;
                    Element e = this.svgp.svgLine(x1, y, x2, y);
                    SVGUtil.addCSSClass(e, CSS_BRACKET);
                    String color = colormap.get(cluster);
                    if (color != null) {
                        SVGUtil.setAtt(e, "style", "stroke:" + color);
                    }
                    this.layer.appendChild(e);
                }
                catch (ClassCastException e) {
                    LOG.warning("Expected OPTICSModel, got: " + cluster.getModel().getClass().getSimpleName());
                }
                It<Cluster<OPTICSModel>> children = clustering.getClusterHierarchy().iterChildren(cluster);
                if (children != null) {
                    this.drawClusters(clustering, children, depth + 1, colormap);
                }
                clusters.advance();
            }
        }

        private void addCSSClasses() {
            if (!this.svgp.getCSSClassManager().contains(CSS_BRACKET)) {
                CSSClass cls = new CSSClass(this, CSS_BRACKET);
                StyleLibrary style = this.context.getStyleLibrary();
                cls.setStatement("stroke", style.getColor("plot"));
                cls.setStatement("stroke-width", style.getLineWidth("plot"));
                this.svgp.addCSSClassOrLogError(cls);
            }
        }
    }
}

