/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.optics;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.opticsplot.OPTICSCut;
import de.lmu.ifi.dbs.elki.visualization.opticsplot.OPTICSPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.OPTICSProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.optics.AbstractOPTICSVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class OPTICSPlotCutVisualization
implements VisFactory {
    private static final String NAME = "OPTICS Cut";

    @Override
    public void processNewResult(VisualizerContext context, Object result) {
        VisualizationTree.findVis(context, result).filter(OPTICSProjector.class).forEach(p -> context.addVis(p, new VisualizationTask(this, NAME, p.getResult(), null).level(1000).with(VisualizationTask.RenderFlag.NO_THUMBNAIL).with(VisualizationTask.RenderFlag.NO_EXPORT)));
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }

    public class Instance
    extends AbstractOPTICSVisualization
    implements DragableArea.DragListener {
        protected static final String CSS_LINE = "opticsPlotLine";
        protected static final String CSS_EPSILON = "opticsPlotEpsilonValue";
        private double epsilon;
        private DragableArea eventarea;
        private Element elemText;
        private Element elementLine;
        private Element elementPoint;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.epsilon = 0.0;
            this.eventarea = null;
            this.elemText = null;
            this.elementLine = null;
            this.elementPoint = null;
        }

        @Override
        public void fullRedraw() {
            this.incrementalRedraw();
        }

        @Override
        public void incrementalRedraw() {
            if (this.layer == null) {
                this.makeLayerElement();
                this.addCSSClasses();
            }
            String label = this.epsilon > 0.0 ? FormatUtil.NF4.format(this.epsilon) : "";
            double yAct = this.getYFromEpsilon(this.epsilon);
            if (this.elemText == null) {
                this.elemText = this.svgp.svgText(105.0, yAct, label);
                SVGUtil.setAtt(this.elemText, "class", CSS_EPSILON);
                this.layer.appendChild(this.elemText);
            } else {
                this.elemText.setTextContent(label);
                SVGUtil.setAtt(this.elemText, "y", yAct);
            }
            if (this.elementLine == null) {
                this.elementLine = this.svgp.svgLine(0.0, yAct, 104.0, yAct);
                SVGUtil.addCSSClass(this.elementLine, CSS_LINE);
                this.layer.appendChild(this.elementLine);
            } else {
                SVGUtil.setAtt(this.elementLine, "y1", yAct);
                SVGUtil.setAtt(this.elementLine, "y2", yAct);
            }
            if (this.elementPoint == null) {
                this.elementPoint = this.svgp.svgCircle(104.0, yAct, 0.4);
                SVGUtil.addCSSClass(this.elementPoint, CSS_LINE);
                this.layer.appendChild(this.elementPoint);
            } else {
                SVGUtil.setAtt(this.elementPoint, "cy", yAct);
            }
            if (this.eventarea == null) {
                this.eventarea = new DragableArea((SVGPlot)this.svgp, 100.0, -1.0, 10.0, this.plotheight + 2.0, this);
                this.layer.appendChild(this.eventarea.getElement());
            }
        }

        @Override
        public void destroy() {
            super.destroy();
            this.eventarea.destroy();
        }

        protected double getEpsilonFromY(double y) {
            OPTICSPlot opticsplot = this.optics.getOPTICSPlot(this.context);
            y = y < 0.0 ? 0.0 : (y > this.plotheight ? 1.0 : y / this.plotheight);
            return this.optics.getOPTICSPlot(this.context).scaleFromPixel(y * (double)opticsplot.getHeight());
        }

        protected double getYFromEpsilon(double epsilon) {
            OPTICSPlot opticsplot = this.optics.getOPTICSPlot(this.context);
            int h = opticsplot.getHeight();
            double y = opticsplot.getScale().getScaled(epsilon, (double)h - 0.5, 0.5) / (double)h * this.plotheight;
            return y < 0.0 ? 0.0 : (y > this.plotheight ? this.plotheight : y);
        }

        @Override
        public boolean startDrag(SVGPoint start, Event evt) {
            this.epsilon = this.getEpsilonFromY(this.plotheight - (double)start.getY());
            this.svgp.requestRedraw(this.task, this);
            return true;
        }

        @Override
        public boolean duringDrag(SVGPoint start, SVGPoint end, Event evt, boolean inside) {
            if (inside) {
                this.epsilon = this.getEpsilonFromY(this.plotheight - (double)end.getY());
            }
            this.svgp.requestRedraw(this.task, this);
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint start, SVGPoint end, Event evt, boolean inside) {
            if (inside) {
                this.epsilon = this.getEpsilonFromY(this.plotheight - (double)end.getY());
                ClusterOrder order = this.optics.getResult();
                Clustering<Model> cl = OPTICSCut.makeOPTICSCut(order, this.epsilon);
                order.addChildResult(cl);
            }
            this.svgp.requestRedraw(this.task, this);
            return true;
        }

        public void unsetEpsilon() {
            this.epsilon = 0.0;
        }

        private void addCSSClasses() {
            StyleLibrary style = this.context.getStyleLibrary();
            if (!this.svgp.getCSSClassManager().contains(CSS_EPSILON)) {
                CSSClass label = new CSSClass(this.svgp, CSS_EPSILON);
                label.setStatement("fill", style.getTextColor("axis.label"));
                label.setStatement("font-family", style.getFontFamily("axis.label"));
                label.setStatement("font-size", style.getTextSize("axis.label"));
                this.svgp.addCSSClassOrLogError(label);
            }
            if (!this.svgp.getCSSClassManager().contains(CSS_LINE)) {
                CSSClass lcls = new CSSClass(this.svgp, CSS_LINE);
                lcls.setStatement("stroke", style.getColor("plot"));
                lcls.setStatement("stroke-width", 0.5 * style.getLineWidth("plot"));
                this.svgp.addCSSClassOrLogError(lcls);
            }
        }
    }
}

