/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.optics;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.OPTICSProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.optics.AbstractOPTICSVisualization;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class OPTICSPlotSelectionVisualization
implements VisFactory {
    private static final Logging LOG = Logging.getLogger(OPTICSPlotSelectionVisualization.class);
    private static final String NAME = "OPTICS Selection";

    @Override
    public void processNewResult(VisualizerContext context, Object result) {
        VisualizationTree.findVis(context, result).filter(OPTICSProjector.class).forEach(p -> context.addVis(p, new VisualizationTask(this, NAME, p.getResult(), null).level(1000).with(VisualizationTask.UpdateFlag.ON_SELECTION)));
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }

    public class Instance
    extends AbstractOPTICSVisualization
    implements DragableArea.DragListener {
        protected static final String CSS_MARKER = "opticsPlotMarker";
        protected static final String CSS_RANGEMARKER = "opticsPlotRangeMarker";
        private Element mtag;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.makeLayerElement();
            this.addCSSClasses();
            this.mtag = this.svgp.svgElement("g");
            this.layer.appendChild(this.mtag);
            this.addMarker();
            this.layer.appendChild(new DragableArea((SVGPlot)this.svgp, 0.0 - this.plotwidth * 0.1, 0.0, this.plotwidth * 1.1, this.plotheight, this).getElement());
        }

        public void addMarker() {
            ClusterOrder order = this.getClusterOrder();
            DBIDSelection selContext = this.context.getSelection();
            if (selContext != null) {
                SetDBIDs selection = DBIDUtil.ensureSet(selContext.getSelectedIds());
                double width = this.plotwidth / (double)order.size();
                int begin = -1;
                int j = 0;
                DBIDArrayIter it = order.iter();
                while (it.valid()) {
                    if (selection.contains(it)) {
                        if (begin == -1) {
                            begin = j;
                        }
                    } else if (begin != -1) {
                        Element marker = this.addMarkerRect((double)begin * width, (double)(j - begin) * width);
                        SVGUtil.addCSSClass(marker, CSS_MARKER);
                        this.mtag.appendChild(marker);
                        begin = -1;
                    }
                    it.advance();
                    ++j;
                }
                if (begin != -1) {
                    Element marker = this.addMarkerRect((double)begin * width, (double)(order.size() - begin) * width);
                    SVGUtil.addCSSClass(marker, CSS_MARKER);
                    this.mtag.appendChild(marker);
                }
            }
        }

        public Element addMarkerRect(double x1, double width) {
            return this.svgp.svgRect(x1, 0.0, width, this.plotheight);
        }

        @Override
        public boolean startDrag(SVGPoint startPoint, Event evt) {
            ClusterOrder order = this.getClusterOrder();
            int mouseActIndex = this.getSelectedIndex(order, startPoint);
            if (mouseActIndex >= 0 && mouseActIndex < order.size()) {
                double width = this.plotwidth / (double)order.size();
                double x1 = (double)mouseActIndex * width;
                Element marker = this.addMarkerRect(x1, width);
                SVGUtil.setCSSClass(marker, CSS_RANGEMARKER);
                this.mtag.appendChild(marker);
                return true;
            }
            return false;
        }

        @Override
        public boolean duringDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
            ClusterOrder order = this.getClusterOrder();
            int mouseDownIndex = this.getSelectedIndex(order, startPoint);
            int mouseActIndex = this.getSelectedIndex(order, dragPoint);
            int begin = Math.max(Math.min(mouseDownIndex, mouseActIndex), 0);
            int end = Math.min(Math.max(mouseDownIndex, mouseActIndex), order.size());
            double width = this.plotwidth / (double)order.size();
            double x1 = (double)begin * width;
            double x2 = (double)end * width + width;
            this.mtag.removeChild(this.mtag.getLastChild());
            Element marker = this.addMarkerRect(x1, x2 - x1);
            SVGUtil.setCSSClass(marker, CSS_RANGEMARKER);
            this.mtag.appendChild(marker);
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
            ClusterOrder order = this.getClusterOrder();
            int mouseDownIndex = this.getSelectedIndex(order, startPoint);
            int mouseActIndex = this.getSelectedIndex(order, dragPoint);
            Mode mode = this.getInputMode(evt);
            int begin = Math.max(Math.min(mouseDownIndex, mouseActIndex), 0);
            int end = Math.min(Math.max(mouseDownIndex, mouseActIndex), order.size());
            this.updateSelection(mode, begin, end);
            return true;
        }

        private Mode getInputMode(Event evt) {
            if (evt instanceof DOMMouseEvent) {
                DOMMouseEvent domme = (DOMMouseEvent)evt;
                return domme.getShiftKey() ? Mode.ADD : (domme.getCtrlKey() ? Mode.INVERT : Mode.REPLACE);
            }
            return Mode.REPLACE;
        }

        private int getSelectedIndex(ClusterOrder order, SVGPoint cPt) {
            return (int)((double)cPt.getX() / this.plotwidth * (double)order.size());
        }

        protected void updateSelection(Mode mode, int begin, int end) {
            ClusterOrder order = this.getClusterOrder();
            if (begin < 0 || begin > end || end >= order.size()) {
                LOG.warning("Invalid range in updateSelection: " + begin + " .. " + end);
                return;
            }
            DBIDSelection selContext = this.context.getSelection();
            HashSetModifiableDBIDs selection = selContext == null || mode == Mode.REPLACE ? DBIDUtil.newHashSet() : DBIDUtil.newHashSet(selContext.getSelectedIds());
            DBIDArrayIter it = order.iter().seek(begin);
            while (it.getOffset() <= end) {
                if (mode == Mode.INVERT) {
                    if (!selection.add(it)) {
                        selection.remove(it);
                    }
                } else {
                    selection.add(it);
                }
                it.advance();
            }
            this.context.setSelection(new DBIDSelection(selection));
        }

        private void addCSSClasses() {
            StyleLibrary style = this.context.getStyleLibrary();
            if (!this.svgp.getCSSClassManager().contains(CSS_MARKER)) {
                CSSClass cls = new CSSClass(this, CSS_MARKER);
                cls.setStatement("fill", style.getColor("plot.selection"));
                cls.setStatement("opacity", style.getOpacity("plot.selection"));
                this.svgp.addCSSClassOrLogError(cls);
            }
            if (!this.svgp.getCSSClassManager().contains(CSS_RANGEMARKER)) {
                CSSClass rcls = new CSSClass(this, CSS_RANGEMARKER);
                rcls.setStatement("fill", style.getColor("plot.selection"));
                rcls.setStatement("opacity", style.getOpacity("plot.selection"));
                this.svgp.addCSSClassOrLogError(rcls);
            }
        }
    }

    private static enum Mode {
        REPLACE,
        ADD,
        INVERT;

    }
}

