/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.optics;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.opticsplot.OPTICSPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.OPTICSProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.optics.AbstractOPTICSVisualization;
import org.w3c.dom.Element;

public class OPTICSPlotVisualizer
implements VisFactory {
    private static final String NAME = "OPTICS Plot";

    @Override
    public void processNewResult(VisualizerContext context, Object result) {
        VisualizationTree.findVis(context, result).filter(OPTICSProjector.class).forEach(p -> context.addVis(p, new VisualizationTask(this, NAME, p.getResult(), null).level(100)));
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }

    public class Instance
    extends AbstractOPTICSVisualization {
        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.makeLayerElement();
            OPTICSPlot opticsplot = this.optics.getOPTICSPlot(this.context);
            String ploturi = opticsplot.getSVGPlotURI();
            Element itag = this.svgp.svgElement("image");
            SVGUtil.setAtt(itag, "preserveAspectRatio", "none");
            SVGUtil.setAtt(itag, "image-rendering", "optimizeSpeed");
            SVGUtil.setAtt(itag, "x", 0);
            SVGUtil.setAtt(itag, "y", 0);
            SVGUtil.setAtt(itag, "width", this.plotwidth);
            SVGUtil.setAtt(itag, "height", this.plotheight);
            itag.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", ploturi);
            this.layer.appendChild(itag);
            LinearScale scale = opticsplot.getScale();
            double y1 = this.plotheight * (double)opticsplot.scaleToPixel(scale.getMin()) / (double)opticsplot.getHeight();
            double y2 = this.plotheight * (double)opticsplot.scaleToPixel(scale.getMax()) / (double)opticsplot.getHeight();
            try {
                StyleLibrary style = this.context.getStyleLibrary();
                SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, scale, 0.0, y1, 0.0, y2, SVGSimpleLinearAxis.LabelStyle.LEFTHAND, style);
                SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, scale, this.plotwidth, y1, this.plotwidth, y2, SVGSimpleLinearAxis.LabelStyle.RIGHTHAND, style);
            }
            catch (CSSClassManager.CSSNamingConflict e) {
                LoggingUtil.exception("CSS naming conflict for axes on OPTICS plot", e);
            }
        }
    }
}

