/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.optics;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSXi;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.opticsplot.OPTICSPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.OPTICSProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.optics.AbstractOPTICSVisualization;
import java.awt.Color;
import org.w3c.dom.Element;

public class OPTICSSteepAreaVisualization
implements VisFactory {
    private static final String NAME = "OPTICS Steep Areas";

    @Override
    public void processNewResult(VisualizerContext context, Object result) {
        VisualizationTree.findVis(context, result).filter(OPTICSProjector.class).forEach(p -> {
            ClusterOrder co = p.getResult();
            It<OPTICSXi.SteepAreaResult> r = co.getHierarchy().iterChildren(co).filter(OPTICSXi.SteepAreaResult.class);
            if (r.valid()) {
                VisualizationTask task = new VisualizationTask(this, NAME, p.getResult(), null).level(101);
                context.addVis(p, task);
                context.addVis(r.get(), task);
            }
        });
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }

    public class Instance
    extends AbstractOPTICSVisualization {
        protected static final String CSS_STEEP_UP = "opticsSteepUp";
        protected static final String CSS_STEEP_DOWN = "opticsSteepDown";
        OPTICSXi.SteepAreaResult areas;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            ClusterOrder co = this.optics.getResult();
            this.areas = co.getHierarchy().iterChildren(co).filter(OPTICSXi.SteepAreaResult.class).get();
        }

        @Override
        public void fullRedraw() {
            this.makeLayerElement();
            this.addCSSClasses();
            OPTICSPlot opticsplot = this.optics.getOPTICSPlot(this.context);
            ClusterOrder co = this.getClusterOrder();
            int oheight = opticsplot.getHeight();
            double xscale = this.plotwidth / (double)co.size();
            double yscale = this.plotheight / (double)oheight;
            DBIDArrayIter tmp = co.iter();
            for (OPTICSXi.SteepArea area : this.areas) {
                boolean down = area instanceof OPTICSXi.SteepDownArea;
                int st = area.getStartIndex();
                int en = area.getEndIndex() + 1;
                double x1 = (double)st + (down ? 1.0 : 0.5);
                double x2 = (double)en + (down ? 0.5 : 0.0);
                double y1 = opticsplot.scaleToPixel(co.getReachability(tmp.seek(st)));
                double y2 = opticsplot.scaleToPixel(en < co.size() ? co.getReachability(tmp.seek(en)) : Double.POSITIVE_INFINITY);
                Element e = this.svgp.svgLine(x1 * xscale, y1 * yscale, x2 * xscale, y2 * yscale);
                SVGUtil.addCSSClass(e, down ? CSS_STEEP_DOWN : CSS_STEEP_UP);
                this.layer.appendChild(e);
            }
        }

        private void addCSSClasses() {
            Color color;
            CSSClass cls;
            StyleLibrary style = this.context.getStyleLibrary();
            if (!this.svgp.getCSSClassManager().contains(CSS_STEEP_DOWN)) {
                cls = new CSSClass(this, CSS_STEEP_DOWN);
                color = SVGUtil.stringToColor(style.getColor("plot"));
                if (color == null) {
                    color = Color.BLACK;
                }
                color = new Color((int)((double)color.getRed() * 0.6), (int)((double)color.getGreen() * 0.6 + 102.4), (int)((double)color.getBlue() * 0.6));
                cls.setStatement("stroke", SVGUtil.colorToString(color));
                cls.setStatement("stroke-width", style.getLineWidth("plot") * 0.5);
                this.svgp.addCSSClassOrLogError(cls);
            }
            if (!this.svgp.getCSSClassManager().contains(CSS_STEEP_UP)) {
                cls = new CSSClass(this, CSS_STEEP_UP);
                color = SVGUtil.stringToColor(style.getColor("plot"));
                if (color == null) {
                    color = Color.BLACK;
                }
                color = new Color((int)((double)color.getRed() * 0.6 + 102.4), (int)((double)color.getGreen() * 0.6), (int)((double)color.getBlue() * 0.6));
                cls.setStatement("stroke", SVGUtil.colorToString(color));
                cls.setStatement("stroke-width", style.getLineWidth("plot") * 0.5);
                this.svgp.addCSSClassOrLogError(cls);
            }
        }
    }
}

