/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.pairsegments;

import de.lmu.ifi.dbs.elki.evaluation.clustering.pairsegments.Segment;
import de.lmu.ifi.dbs.elki.evaluation.clustering.pairsegments.Segments;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGCheckbox;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.pairsegments.SegmentsStylingPolicy;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;

@Reference(authors="Elke Achtert, Sascha Goldhofer, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Evaluation of Clusterings - Metrics and Visual Support", booktitle="Proc. 28th International Conference on Data Engineering (ICDE 2012)", url="https://doi.org/10.1109/ICDE.2012.128", bibkey="DBLP:conf/icde/AchtertGKSZ12")
public class CircleSegmentsVisualizer
implements VisFactory {
    private static final Logging LOG = Logging.getLogger(CircleSegmentsVisualizer.class);
    private static final String NAME = "CircleSegments";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewResults(context, start).filter(Segments.class).forEach(segmentResult -> {
            SegmentsStylingPolicy policy;
            It<SegmentsStylingPolicy> it = VisualizationTree.findVis(context, segmentResult).filter(SegmentsStylingPolicy.class);
            if (it.valid()) {
                policy = it.get();
            } else {
                policy = new SegmentsStylingPolicy((Segments)segmentResult);
                context.addVis(segmentResult, policy);
            }
            context.addVis(segmentResult, new VisualizationTask(this, NAME, policy, null).requestSize(2.0, 2.0).level(1000).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY));
        });
    }

    public class Instance
    extends AbstractVisualization
    implements ResultListener {
        private static final double SEGMENT_MIN_ANGLE = 0.01;
        private static final double SEGMENT_MIN_SEP_ANGLE = 0.005;
        private static final double RADIUS_INNER = 4.0;
        private static final double RADIUS_DISTANCE = 1.0;
        private static final double RADIUS_OUTER = 47.0;
        private static final double RADIUS_SELECTION = 2.0;
        private static final String CLR_CLUSTER_CLASS_PREFIX = "clusterSegment";
        public static final String CLR_BORDER_CLASS = "clusterBorder";
        public static final String CLR_UNPAIRED_CLASS = "clusterUnpaired";
        public static final String CLR_HOVER_CLASS = "clusterHover";
        public static final String SEG_UNPAIRED_SELECTED_CLASS = "unpairedSegmentSelected";
        public static final String STYLE = "segments";
        public static final String STYLE_BORDER = "segments.border";
        public static final String STYLE_HOVER = "segments.hover";
        public static final String STYLE_GRADIENT_FIRST = "segments.cluster.first";
        public static final String STYLE_GRADIENT_SECOND = "segments.cluster.second";
        protected final Segments segments;
        private Element visLayer;
        private Element ctrlLayer;
        public Map<Segment, List<Element>> segmentToElements;
        boolean showUnclusteredPairs;
        protected final SegmentsStylingPolicy policy;
        private boolean noIncrementalRedraw;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height) {
            super(context, task, plot, width, height);
            this.segmentToElements = new HashMap<Segment, List<Element>>();
            this.showUnclusteredPairs = false;
            this.noIncrementalRedraw = true;
            this.policy = (SegmentsStylingPolicy)task.getResult();
            this.segments = this.policy.segments;
            this.policy.setStyleLibrary(context.getStyleLibrary());
            this.addListeners();
        }

        public void toggleUnclusteredPairs(boolean show) {
            this.noIncrementalRedraw = true;
            this.showUnclusteredPairs = show;
            this.svgp.requestRedraw(this.task, this);
        }

        @Override
        public void resultChanged(Result current) {
            super.resultChanged(current);
            if (current == this.context.getStylingPolicy() && this.context.getStylingPolicy() != this.policy) {
                this.policy.deselectAllSegments();
            }
        }

        @Override
        public void incrementalRedraw() {
            if (this.noIncrementalRedraw) {
                super.incrementalRedraw();
            } else {
                this.redrawSelection();
            }
        }

        @Override
        public void fullRedraw() {
            LOG.debug("Full redraw");
            this.noIncrementalRedraw = false;
            this.addCSSClasses(this.segments.getHighestClusterCount());
            this.layer = this.svgp.svgElement("g");
            this.visLayer = this.svgp.svgElement("g");
            String transform = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), 100.0, 100.0, 0.0) + "  translate(" + 50.0 + " " + 50.0 + ")";
            this.visLayer.setAttribute("transform", transform);
            this.ctrlLayer = this.svgp.svgElement("g");
            this.drawSegments();
            SVGCheckbox checkbox = new SVGCheckbox(this.showUnclusteredPairs, "Show unclustered pairs");
            checkbox.addCheckBoxListener(e -> this.toggleUnclusteredPairs(((SVGCheckbox)e.getSource()).isChecked()));
            Element clrInfo = this.drawClusteringInfo();
            Element c = checkbox.renderCheckBox(this.svgp, 1.0, 5.0 + ParseUtil.parseDouble(clrInfo.getAttribute("height")), 11.0);
            this.ctrlLayer.appendChild(clrInfo);
            this.ctrlLayer.appendChild(c);
            this.ctrlLayer.setAttribute("transform", "scale(0.0025)");
            this.layer.appendChild(this.visLayer);
            this.layer.appendChild(this.ctrlLayer);
        }

        protected void addCSSClasses(int maxClusterSize) {
            StyleLibrary style = this.context.getStyleLibrary();
            CSSClass cssReferenceBorder = new CSSClass(this.getClass(), CLR_BORDER_CLASS);
            cssReferenceBorder.setStatement("fill", style.getColor(STYLE_BORDER));
            this.svgp.addCSSClassOrLogError(cssReferenceBorder);
            CSSClass cluster_hover = new CSSClass(this.getClass(), CLR_HOVER_CLASS);
            cluster_hover.setStatement("fill", style.getColor(STYLE_HOVER) + " !important");
            cluster_hover.setStatement("cursor", "pointer");
            this.svgp.addCSSClassOrLogError(cluster_hover);
            CSSClass cluster_unpaired = new CSSClass(this.getClass(), CLR_UNPAIRED_CLASS);
            cluster_unpaired.setStatement("fill", style.getBackgroundColor(STYLE));
            cluster_unpaired.setStatement("stroke", "none");
            this.svgp.addCSSClassOrLogError(cluster_unpaired);
            CSSClass cluster_unpaired_s = new CSSClass(this.getClass(), SEG_UNPAIRED_SELECTED_CLASS);
            cluster_unpaired_s.setStatement("fill", style.getColor(STYLE_HOVER) + " !important");
            this.svgp.addCSSClassOrLogError(cluster_unpaired_s);
            String firstcol = style.getColor(STYLE_GRADIENT_FIRST);
            String secondcol = style.getColor(STYLE_GRADIENT_SECOND);
            String[] clusterColorShades = this.makeGradient(maxClusterSize, new String[]{firstcol, secondcol});
            for (int i = 0; i < maxClusterSize; ++i) {
                CSSClass clusterClasses = new CSSClass(CircleSegmentsVisualizer.class, "clusterSegment_" + i);
                clusterClasses.setStatement("fill", clusterColorShades[i]);
                clusterClasses.setStatement("stroke", "none");
                this.svgp.addCSSClassOrLogError(clusterClasses);
            }
        }

        private void drawSegments() {
            StyleLibrary style = this.context.getStyleLibrary();
            int clusterings = this.segments.getClusterings();
            this.segmentToElements.clear();
            double angle_pair = (Math.PI * 2 - 0.005 * (double)this.segments.size()) / (double)this.segments.getPairCount(this.showUnclusteredPairs);
            int pair_min_count = (int)Math.ceil(0.01 / angle_pair);
            int cluster_min_count = 0;
            for (Segment segment : this.segments) {
                if (segment.getPairCount() > (long)pair_min_count) continue;
                ++cluster_min_count;
            }
            angle_pair = (Math.PI * 2 - (0.005 * (double)this.segments.size() + (double)cluster_min_count * 0.01)) / (double)(this.segments.getPairCount(this.showUnclusteredPairs) - (long)cluster_min_count);
            double radius_delta = (43.0 - (double)clusterings * 1.0) / (double)clusterings;
            double border_width = 0.005;
            int refClustering = 0;
            int refSegment = -1;
            double offsetAngle = 0.0;
            for (Segment segment : this.segments) {
                long currentPairCount = segment.getPairCount();
                double alpha = 0.01;
                if (currentPairCount > (long)pair_min_count) {
                    alpha = angle_pair * (double)currentPairCount;
                }
                ArrayList<Element> elems = new ArrayList<Element>(clusterings);
                this.segmentToElements.put(segment, elems);
                for (int i = 0; i < clusterings; ++i) {
                    double currentRadius = (double)i * (radius_delta + 1.0) + 4.0;
                    if (refSegment != segment.get(refClustering) && refClustering == i) {
                        Element border = SVGUtil.svgCircleSegment(this.svgp, 0.0, 0.0, offsetAngle - 0.005, border_width, currentRadius, 46.0);
                        border.setAttribute("class", CLR_BORDER_CLASS);
                        this.visLayer.appendChild(border);
                        if (segment.get(refClustering) == -1) {
                            refClustering = Math.min(refClustering + 1, clusterings - 1);
                        }
                        refSegment = segment.get(refClustering);
                    }
                    int cluster = segment.get(i);
                    Element segelement = SVGUtil.svgCircleSegment(this.svgp, 0.0, 0.0, offsetAngle, alpha, currentRadius, currentRadius + radius_delta);
                    elems.add(segelement);
                    SegmentListenerProxy listener = new SegmentListenerProxy(segment, i);
                    EventTarget targ = (EventTarget)((Object)segelement);
                    targ.addEventListener("mouseover", listener, false);
                    targ.addEventListener("mouseout", listener, false);
                    targ.addEventListener("click", listener, false);
                    if (cluster >= 0) {
                        segelement.setAttribute("class", "clusterSegment_" + cluster);
                    } else {
                        segelement.setAttribute("class", CLR_UNPAIRED_CLASS);
                    }
                    this.visLayer.appendChild(segelement);
                }
                double currentRadius = (double)clusterings * (radius_delta + 1.0) + 4.0;
                Element extension = SVGUtil.svgCircleSegment(this.svgp, 0.0, 0.0, offsetAngle, alpha, currentRadius, currentRadius + 2.0);
                extension.setAttribute("class", CLR_UNPAIRED_CLASS);
                elems.add(extension);
                if (segment.isUnpaired()) {
                    if (this.policy.isSelected(segment)) {
                        SVGUtil.addCSSClass(extension, SEG_UNPAIRED_SELECTED_CLASS);
                    } else {
                        SVGUtil.removeCSSClass(extension, SEG_UNPAIRED_SELECTED_CLASS);
                    }
                } else {
                    int idx = this.policy.indexOfSegment(segment);
                    if (idx >= 0) {
                        String color = style.getColorSet("plot").getColor(idx);
                        extension.setAttribute("style", "fill:" + color);
                    } else {
                        extension.removeAttribute("style");
                    }
                }
                this.visLayer.appendChild(extension);
                offsetAngle += alpha + 0.005;
            }
        }

        private void redrawSelection() {
            StyleLibrary style = this.context.getStyleLibrary();
            LOG.debug("Updating selection only.");
            for (Map.Entry<Segment, List<Element>> entry : this.segmentToElements.entrySet()) {
                Segment segment = entry.getKey();
                Element extension = entry.getValue().get(this.segments.getClusterings());
                if (segment.isUnpaired()) {
                    if (this.policy.isSelected(segment)) {
                        SVGUtil.addCSSClass(extension, SEG_UNPAIRED_SELECTED_CLASS);
                        continue;
                    }
                    SVGUtil.removeCSSClass(extension, SEG_UNPAIRED_SELECTED_CLASS);
                    continue;
                }
                int idx = this.policy.indexOfSegment(segment);
                if (idx >= 0) {
                    String color = style.getColorSet("plot").getColor(idx);
                    extension.setAttribute("style", "fill:" + color);
                    continue;
                }
                extension.removeAttribute("style");
            }
        }

        protected String[] makeGradient(int shades, String[] colors) {
            if (shades <= colors.length) {
                return colors;
            }
            Color[] cols = new Color[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                cols[i] = SVGUtil.stringToColor(colors[i]);
                if (cols[i] != null) continue;
                throw new AbortException("Error parsing color: " + colors[i]);
            }
            double increment = ((double)cols.length - 1.0) / (double)shades;
            String[] colorShades = new String[shades];
            for (int s = 0; s < shades; ++s) {
                int npos;
                int ppos = Math.min((int)Math.floor(increment * (double)s), cols.length - 1);
                if (ppos == (npos = Math.min((int)Math.ceil(increment * (double)s), cols.length - 1))) {
                    colorShades[s] = colors[ppos];
                    continue;
                }
                Color prev = cols[ppos];
                Color next = cols[npos];
                double mix = (increment * (double)s - (double)ppos) / (double)(npos - ppos);
                int r = (int)((1.0 - mix) * (double)prev.getRed() + mix * (double)next.getRed());
                int g = (int)((1.0 - mix) * (double)prev.getGreen() + mix * (double)next.getGreen());
                int b = (int)((1.0 - mix) * (double)prev.getBlue() + mix * (double)next.getBlue());
                colorShades[s] = SVGUtil.colorToString((r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
            }
            return colorShades;
        }

        protected Element drawClusteringInfo() {
            Element thumbnail = SVGUtil.svgElement(this.svgp.getDocument(), "g");
            int startRadius = 4;
            int singleHeight = 12;
            int margin = 4;
            int radius = this.segments.getClusterings() * (singleHeight + margin) + startRadius;
            SVGUtil.setAtt(thumbnail, "height", radius);
            for (int i = 0; i < this.segments.getClusterings(); ++i) {
                double innerRadius = i * singleHeight + margin * i + startRadius;
                Element clr = SVGUtil.svgCircleSegment(this.svgp, radius - startRadius, radius - startRadius, 4.71238898038469, 1.5707963267948966, innerRadius, innerRadius + (double)singleHeight);
                clr.setAttribute("fill", "#d4e4f1");
                clr.setAttribute("stroke", "#a0a0a0");
                clr.setAttribute("stroke-width", "1.0");
                String labelText = this.segments.getClusteringDescription(i);
                Element label = this.svgp.svgText(radius + startRadius, (double)radius - innerRadius - (double)startRadius, labelText);
                thumbnail.appendChild(label);
                thumbnail.appendChild(clr);
            }
            return thumbnail;
        }

        protected void segmentHover(Segment segment, int ringid, boolean active) {
            if (active) {
                if (segment.isNone()) {
                    return;
                }
                if (LOG.isDebugging()) {
                    LOG.debug("Hover on segment: " + segment + " unpaired: " + segment.isUnpaired());
                }
                if (!segment.isUnpaired()) {
                    for (Map.Entry<Segment, List<Element>> entry : this.segmentToElements.entrySet()) {
                        Segment other = entry.getKey();
                        if (other.get(ringid) != segment.get(ringid)) continue;
                        Element ringSegment = entry.getValue().get(ringid);
                        SVGUtil.addCSSClass(ringSegment, CLR_HOVER_CLASS);
                    }
                } else {
                    List<Segment> paired = this.segments.getPairedSegments(segment);
                    for (Segment other : paired) {
                        Element ringSegment = this.segmentToElements.get(other).get(ringid);
                        SVGUtil.addCSSClass(ringSegment, CLR_HOVER_CLASS);
                    }
                }
            } else {
                for (List<Element> elems : this.segmentToElements.values()) {
                    for (Element current : elems) {
                        SVGUtil.removeCSSClass(current, CLR_HOVER_CLASS);
                    }
                }
            }
        }

        protected void segmentClick(Segment segment, Event evt, boolean dblClick) {
            MouseEvent mouse = (MouseEvent)evt;
            boolean ctrl = false;
            if (mouse.getCtrlKey()) {
                ctrl = true;
            }
            if (dblClick) {
                this.policy.deselectAllSegments();
            }
            this.policy.select(segment, ctrl);
            this.context.setStylingPolicy(this.policy);
        }

        private class SegmentListenerProxy
        implements EventListener {
            public static final int EVT_DBLCLICK_DELAY = 350;
            private Segment id;
            private int ringid;
            private long lastClick = 0L;

            public SegmentListenerProxy(Segment id, int ringid) {
                this.id = id;
                this.ringid = ringid;
            }

            @Override
            public void handleEvent(Event evt) {
                if ("mouseover".equals(evt.getType())) {
                    Instance.this.segmentHover(this.id, this.ringid, true);
                }
                if ("mouseout".equals(evt.getType())) {
                    Instance.this.segmentHover(this.id, this.ringid, false);
                }
                if ("click".equals(evt.getType())) {
                    long time = Calendar.getInstance().getTimeInMillis();
                    boolean dblClick = time - this.lastClick <= 350L;
                    this.lastClick = time;
                    Instance.this.segmentClick(this.id, evt, dblClick);
                }
            }
        }
    }
}

