/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.pairsegments;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.clustering.pairsegments.Segment;
import de.lmu.ifi.dbs.elki.evaluation.clustering.pairsegments.Segments;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SegmentsStylingPolicy
implements ClassStylingPolicy {
    protected final Segments segments;
    protected ArrayList<Segment> selectedSegments = new ArrayList();
    protected TreeMap<Segment, Segment> indirectSelections = new TreeMap();
    protected ModifiableDBIDs unselectedObjects = DBIDUtil.newHashSet();
    ColorLibrary colorset = null;

    public SegmentsStylingPolicy(Segments segments) {
        this.segments = segments;
        for (Segment segment : segments) {
            if (segment.isUnpaired() || segment.getDBIDs() == null) continue;
            this.unselectedObjects.addDBIDs(segment.getDBIDs());
        }
    }

    public void setStyleLibrary(StyleLibrary style) {
        this.colorset = style.getColorSet("plot");
    }

    public boolean isSelected(Segment segment) {
        return this.selectedSegments.contains(segment) || this.indirectSelections.containsValue(segment);
    }

    @Override
    public int getStyleForDBID(DBIDRef id) {
        Iterator<Segment> s = this.selectedSegments.iterator();
        int i = 0;
        while (s.hasNext()) {
            Segment seg = s.next();
            DBIDs ids = seg.getDBIDs();
            if (ids != null && ids.contains(id)) {
                return i;
            }
            ++i;
        }
        return -2;
    }

    @Override
    public int getColorForDBID(DBIDRef id) {
        int style = this.getStyleForDBID(id);
        if (this.colorset != null) {
            return SVGUtil.stringToColor(this.colorset.getColor(style)).getRGB();
        }
        return 0;
    }

    @Override
    public int getMinStyle() {
        return -2;
    }

    @Override
    public int getMaxStyle() {
        return this.selectedSegments.size();
    }

    @Override
    public DBIDIter iterateClass(int cnum) {
        if (cnum == -2) {
            return this.unselectedObjects.iter();
        }
        if (cnum == -1) {
            return DBIDUtil.EMPTYDBIDS.iter();
        }
        DBIDs ids = this.selectedSegments.get(cnum).getDBIDs();
        return ids != null ? ids.iter() : DBIDUtil.EMPTYDBIDS.iter();
    }

    @Override
    public int classSize(int cnum) {
        if (cnum == -2) {
            return this.unselectedObjects.size();
        }
        if (cnum == -1) {
            return 0;
        }
        DBIDs ids = this.selectedSegments.get(cnum).getDBIDs();
        return ids != null ? ids.size() : 0;
    }

    public void select(Segment segment, boolean addToSelection) {
        if (segment.isNone()) {
            return;
        }
        if (!addToSelection) {
            this.deselectAllSegments();
        }
        if (segment.isUnpaired()) {
            if (addToSelection) {
                boolean allSegmentsSelected = true;
                for (Segment other : this.segments.getPairedSegments(segment)) {
                    if (this.isSelected(other)) continue;
                    allSegmentsSelected = false;
                    break;
                }
                if (allSegmentsSelected) {
                    this.deselectSegment(segment);
                    return;
                }
            }
            if (this.isSelected(segment)) {
                this.deselectSegment(segment);
            } else {
                this.selectSegment(segment);
            }
        } else if (this.isSelected(segment)) {
            this.deselectSegment(segment);
        } else {
            this.selectSegment(segment);
        }
    }

    public void deselectAllSegments() {
        while (!this.selectedSegments.isEmpty()) {
            this.deselectSegment(this.selectedSegments.get(this.selectedSegments.size() - 1));
        }
    }

    protected void deselectSegment(Segment segment) {
        if (segment.isUnpaired()) {
            ArrayList<Segment> remove = new ArrayList<Segment>();
            for (Map.Entry<Segment, Segment> entry : this.indirectSelections.entrySet()) {
                if (entry.getValue() != segment) continue;
                remove.add(entry.getKey());
            }
            for (Segment other : remove) {
                this.indirectSelections.remove(other);
                this.deselectSegment(other);
            }
        } else {
            Segment unpaired = this.indirectSelections.get(segment);
            if (unpaired != null) {
                this.deselectSegment(unpaired);
            }
            if (this.selectedSegments.remove(segment) && segment.getDBIDs() != null) {
                this.unselectedObjects.addDBIDs(segment.getDBIDs());
            }
        }
    }

    protected void selectSegment(Segment segment) {
        if (segment.isUnpaired()) {
            for (Segment other : this.segments.getPairedSegments(segment)) {
                this.indirectSelections.put(other, segment);
                this.selectSegment(other);
            }
        } else if (!this.selectedSegments.contains(segment)) {
            this.selectedSegments.add(segment);
            if (segment.getDBIDs() != null) {
                this.unselectedObjects.removeDBIDs(segment.getDBIDs());
            }
        }
    }

    public int indexOfSegment(Segment segment) {
        return this.selectedSegments.indexOf(segment);
    }

    @Override
    public String getMenuName() {
        return "Pair segments styling policy";
    }
}

