/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel;

import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.ProjectionParallel;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import org.w3c.dom.Element;

public abstract class AbstractParallelVisualization<NV>
extends AbstractVisualization {
    protected final ProjectionParallel proj;
    protected final Relation<NV> relation;
    final double[] margins;
    protected double axsep;
    final double[] size;

    public AbstractParallelVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        super(context, task, plot, width, height);
        this.proj = (ProjectionParallel)proj;
        this.relation = task.getRelation();
        this.margins = new double[]{5.0, 10.0, 5.0, 10.0};
        double ratio = (width * 100.0 - this.margins[0] - this.margins[2]) / (height * 100.0 - this.margins[1] - this.margins[3]);
        this.size = new double[]{ratio * 100.0, 100.0};
        this.recalcAxisPositions();
    }

    @Override
    public void fullRedraw() {
        this.layer = this.setupCanvas(this.svgp, this.proj, this.getWidth(), this.getHeight());
    }

    public Element setupCanvas(SVGPlot svgp, ProjectionParallel proj, double width, double height) {
        Element layer = SVGUtil.svgElement(svgp.getDocument(), "g");
        String transform = SVGUtil.makeMarginTransform(width, height, this.size[0], this.size[1], this.margins[0], this.margins[1], this.margins[2], this.margins[3]);
        SVGUtil.setAtt(layer, "transform", transform);
        return layer;
    }

    protected double getSizeX() {
        return this.size[0];
    }

    protected double getSizeY() {
        return this.size[1];
    }

    protected double getMarginLeft() {
        return this.margins[0];
    }

    protected double getMarginTop() {
        return this.margins[1];
    }

    protected double getAxisSep() {
        return this.axsep;
    }

    private void recalcAxisPositions() {
        this.axsep = this.size[0] / ((double)this.proj.getVisibleDimensions() - 1.0);
    }

    protected double getVisibleAxisX(double d) {
        return d * this.axsep;
    }

    @Override
    public void visualizationChanged(VisualizationItem item) {
        super.visualizationChanged(item);
        if (item == this.proj) {
            this.recalcAxisPositions();
            this.svgp.requestRedraw(this.task, this);
            return;
        }
    }
}

