/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGArrow;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class AxisReorderVisualization
implements VisFactory {
    private static final String NAME = "Dimension Ordering Tool";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ParallelPlotProjector.class).forEach(p -> context.addVis(p, new VisualizationTask(this, NAME, p.getRelation(), p.getRelation()).level(1000).with(VisualizationTask.RenderFlag.NO_THUMBNAIL).with(VisualizationTask.RenderFlag.NO_EXPORT)));
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector> {
        public static final String SELECTDIMENSIONORDER = "SelectDimensionOrder";
        public static final String SDO_BUTTON = "DObutton";
        public static final String SDO_BORDER = "DOborder";
        public static final String SDO_ARROW = "DOarrow";
        private int selecteddim;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.selecteddim = -1;
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            this.addCSSClasses(this.svgp);
            int dim = this.proj.getVisibleDimensions();
            double controlsize = 0.025 * this.getSizeY();
            double buttonsize = 0.75 * controlsize;
            double padding = 0.125 * controlsize;
            double arrowsize = 0.75 * buttonsize;
            double ypos = this.getSizeY() + this.getMarginTop() * 0.5 + controlsize;
            double spacing = 0.9 * controlsize;
            Element back = this.svgp.svgRect(-controlsize * 0.5, ypos, this.getSizeX() + controlsize, controlsize);
            SVGUtil.addCSSClass(back, SELECTDIMENSIONORDER);
            this.layer.appendChild(back);
            if (this.selecteddim < 0) {
                for (int i = 0; i < dim; ++i) {
                    Element button;
                    Element arrow;
                    double xpos = this.getVisibleAxisX(i);
                    if (i > 0) {
                        arrow = SVGArrow.makeArrow(this.svgp, SVGArrow.Direction.LEFT, xpos - spacing, ypos + controlsize * 0.5, arrowsize);
                        SVGUtil.addCSSClass(arrow, SDO_ARROW);
                        this.layer.appendChild(arrow);
                        button = this.svgp.svgRect(xpos - spacing - buttonsize * 0.5, ypos + padding, buttonsize, buttonsize);
                        SVGUtil.addCSSClass(button, SDO_BUTTON);
                        this.addEventListener(button, i, SVGArrow.Direction.LEFT);
                        this.layer.appendChild(button);
                    }
                    arrow = SVGArrow.makeArrow(this.svgp, SVGArrow.Direction.DOWN, xpos, ypos + controlsize * 0.5, arrowsize);
                    SVGUtil.addCSSClass(arrow, SDO_ARROW);
                    this.layer.appendChild(arrow);
                    button = this.svgp.svgRect(xpos - buttonsize * 0.5, ypos + padding, buttonsize, buttonsize);
                    SVGUtil.addCSSClass(button, SDO_BUTTON);
                    this.addEventListener(button, i, SVGArrow.Direction.DOWN);
                    this.layer.appendChild(button);
                    if (i >= dim - 1) continue;
                    arrow = SVGArrow.makeArrow(this.svgp, SVGArrow.Direction.RIGHT, xpos + spacing, ypos + controlsize * 0.5, arrowsize);
                    SVGUtil.addCSSClass(arrow, SDO_ARROW);
                    this.layer.appendChild(arrow);
                    button = this.svgp.svgRect(xpos + spacing - buttonsize * 0.5, ypos + padding, buttonsize, buttonsize);
                    SVGUtil.addCSSClass(button, SDO_BUTTON);
                    this.addEventListener(button, i, SVGArrow.Direction.RIGHT);
                    this.layer.appendChild(button);
                }
            } else {
                for (int i = 0; i < dim; ++i) {
                    Element arrow = SVGArrow.makeArrow(this.svgp, SVGArrow.Direction.DOWN, this.getVisibleAxisX(i), ypos + controlsize * 0.5, arrowsize);
                    SVGUtil.addCSSClass(arrow, SDO_ARROW);
                    this.layer.appendChild(arrow);
                    Element button = this.svgp.svgRect(this.getVisibleAxisX(i) - buttonsize * 0.5, ypos + padding, buttonsize, buttonsize);
                    SVGUtil.addCSSClass(button, SDO_BUTTON);
                    this.addEventListener(button, i, SVGArrow.Direction.DOWN);
                    this.layer.appendChild(button);
                    if (!((double)i > 0.0)) continue;
                    arrow = SVGArrow.makeArrow(this.svgp, SVGArrow.Direction.UP, this.getVisibleAxisX((double)i - 0.5), ypos + controlsize * 0.5, arrowsize);
                    SVGUtil.addCSSClass(arrow, SDO_ARROW);
                    this.layer.appendChild(arrow);
                    button = this.svgp.svgRect(this.getVisibleAxisX((double)i - 0.5) - buttonsize * 0.5, ypos + padding, buttonsize, buttonsize);
                    SVGUtil.addCSSClass(button, SDO_BUTTON);
                    this.addEventListener(button, i, SVGArrow.Direction.UP);
                    this.layer.appendChild(button);
                }
            }
        }

        private void addEventListener(Element tag, final int i, final SVGArrow.Direction j) {
            EventTarget targ = (EventTarget)((Object)tag);
            targ.addEventListener("click", new EventListener(){

                @Override
                public void handleEvent(Event evt) {
                    if (Instance.this.selecteddim < 0) {
                        switch (j) {
                            case DOWN: {
                                Instance.this.selecteddim = i;
                                break;
                            }
                            case LEFT: {
                                int prev;
                                for (prev = i - 1; prev >= 0 && !Instance.this.proj.isAxisVisible(prev); --prev) {
                                }
                                Instance.this.proj.swapAxes(i, prev);
                                break;
                            }
                            case RIGHT: {
                                int next;
                                for (next = i + 1; next < Instance.this.proj.getInputDimensionality() - 1 && !Instance.this.proj.isAxisVisible(next); ++next) {
                                }
                                Instance.this.proj.swapAxes(i, next);
                                break;
                            }
                        }
                    } else {
                        switch (j) {
                            case DOWN: {
                                Instance.this.proj.swapAxes(Instance.this.selecteddim, i);
                                Instance.this.selecteddim = -1;
                                break;
                            }
                            case UP: {
                                if (Instance.this.selecteddim != i) {
                                    Instance.this.proj.moveAxis(Instance.this.selecteddim, i);
                                }
                                Instance.this.selecteddim = -1;
                                break;
                            }
                        }
                    }
                    Instance.this.context.visChanged(Instance.this.proj);
                }
            }, false);
        }

        private void addCSSClasses(SVGPlot svgp) {
            CSSClass cls;
            StyleLibrary style = this.context.getStyleLibrary();
            if (!svgp.getCSSClassManager().contains(SELECTDIMENSIONORDER)) {
                cls = new CSSClass(this, SELECTDIMENSIONORDER);
                cls.setStatement("opacity", 0.1);
                cls.setStatement("fill", "blue");
                svgp.addCSSClassOrLogError(cls);
            }
            if (!svgp.getCSSClassManager().contains(SDO_BORDER)) {
                cls = new CSSClass(this, SDO_BORDER);
                cls.setStatement("stroke", "grey");
                cls.setStatement("stroke-width", style.getLineWidth("plot") / 3.0);
                cls.setStatement("fill", "none");
                svgp.addCSSClassOrLogError(cls);
            }
            if (!svgp.getCSSClassManager().contains(SDO_BUTTON)) {
                cls = new CSSClass(this, SDO_BUTTON);
                cls.setStatement("opacity", 0.01);
                cls.setStatement("fill", "grey");
                cls.setStatement("cursor", "pointer");
                svgp.addCSSClassOrLogError(cls);
            }
            if (!svgp.getCSSClassManager().contains(SDO_ARROW)) {
                cls = new CSSClass(this, SDO_ARROW);
                cls.setStatement("stroke", "darkgrey");
                cls.setStatement("stroke-width", style.getLineWidth("plot") / 3.0);
                cls.setStatement("fill", "black");
                svgp.addCSSClassOrLogError(cls);
            }
        }
    }
}

