/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class AxisVisibilityVisualization
implements VisFactory {
    private static final String NAME = "Axis Visibility";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ParallelPlotProjector.class).forEach(p -> context.addVis(p, new VisualizationTask(this, NAME, p.getRelation(), p.getRelation()).level(1000).with(VisualizationTask.RenderFlag.NO_THUMBNAIL).with(VisualizationTask.RenderFlag.NO_EXPORT)));
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector> {
        public static final String SELECTAXISVISIBILITY = "SelectAxisVisibility";
        public static final String SAV_BUTTON = "SAVbutton";
        public static final String SAV_BORDER = "SAVborder";
        public static final String SAV_CROSS = "SAVbuttoncross";
        double controlsize;
        double buttonsize;
        double ypos;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            int dim = this.proj.getInputDimensionality();
            this.addCSSClasses(this.svgp);
            this.controlsize = 0.025 * this.getSizeY();
            this.buttonsize = 0.75 * this.controlsize;
            this.ypos = this.getSizeY() + this.getMarginTop() * 0.5;
            Element back = this.svgp.svgRect(-this.controlsize * 0.5, this.ypos - this.controlsize * 0.5 + this.buttonsize * 0.5, this.getSizeX() + this.controlsize, this.controlsize);
            SVGUtil.addCSSClass(back, SELECTAXISVISIBILITY);
            this.layer.appendChild(back);
            int hidden = 0;
            int vax = 0;
            for (int i = 0; i <= dim; ++i) {
                if (i < dim && !this.proj.isAxisVisible(i)) {
                    ++hidden;
                    continue;
                }
                if (hidden > 0) {
                    this.makeButtonsForHidden(vax, i - hidden, hidden, dim);
                    hidden = 0;
                }
                if (i >= dim) continue;
                this.makeButtonForVisible(i, vax);
                ++vax;
            }
        }

        protected void makeButtonForVisible(int anum, int apos) {
            double xpos = this.getVisibleAxisX(apos) - this.buttonsize * 0.5;
            Element border = this.svgp.svgRect(xpos, this.ypos, this.buttonsize, this.buttonsize);
            SVGUtil.addCSSClass(border, SAV_BORDER);
            this.layer.appendChild(border);
            SVGPath path = new SVGPath();
            double qs = this.controlsize * 0.5;
            double cs = this.controlsize * 0.125;
            path.moveTo(xpos + cs, this.ypos + cs);
            path.relativeLineTo(qs, qs);
            path.relativeMoveTo(0.0, -qs);
            path.relativeLineTo(-qs, qs);
            this.layer.appendChild(path.makeElement(this.svgp, SAV_CROSS));
            Element rect = this.svgp.svgRect(xpos, this.ypos, this.buttonsize, this.buttonsize);
            SVGUtil.addCSSClass(rect, SAV_BUTTON);
            this.addEventListener(rect, anum);
            this.layer.appendChild(rect);
        }

        private void makeButtonsForHidden(int vnum, int first, int count, int dim) {
            double lpos = vnum == 0 ? -this.getMarginLeft() : this.getVisibleAxisX(vnum - 1);
            double rpos = first + count + 1 >= dim ? this.getWidth() + this.getMarginLeft() : this.getVisibleAxisX(vnum);
            double step = (rpos - lpos) / ((double)count + 1.0);
            for (int j = 0; j < count; ++j) {
                double apos = lpos + (double)(j + 1) * step - this.buttonsize * 0.5;
                Element border = this.svgp.svgRect(apos, this.ypos, this.buttonsize, this.buttonsize);
                SVGUtil.addCSSClass(border, SAV_BORDER);
                this.layer.appendChild(border);
                Element rect = this.svgp.svgRect(apos, this.ypos, this.buttonsize, this.buttonsize);
                SVGUtil.addCSSClass(rect, SAV_BUTTON);
                this.addEventListener(rect, first + j);
                this.layer.appendChild(rect);
            }
        }

        private void addEventListener(Element tag, final int axis) {
            EventTarget targ = (EventTarget)((Object)tag);
            targ.addEventListener("click", new EventListener(){

                @Override
                public void handleEvent(Event evt) {
                    if (Instance.this.proj.getVisibleDimensions() > 2) {
                        Instance.this.proj.toggleAxisVisible(axis);
                        Instance.this.context.visChanged(Instance.this.proj);
                    }
                }
            }, false);
        }

        private void addCSSClasses(SVGPlot svgp) {
            CSSClass cls;
            StyleLibrary style = this.context.getStyleLibrary();
            if (!svgp.getCSSClassManager().contains(SELECTAXISVISIBILITY)) {
                cls = new CSSClass(this, SELECTAXISVISIBILITY);
                cls.setStatement("opacity", 0.1);
                cls.setStatement("fill", "blue");
                svgp.addCSSClassOrLogError(cls);
            }
            if (!svgp.getCSSClassManager().contains(SAV_BORDER)) {
                cls = new CSSClass(this, SAV_BORDER);
                cls.setStatement("stroke", "grey");
                cls.setStatement("stroke-width", style.getLineWidth("plot") * 0.5);
                cls.setStatement("fill", "none");
                svgp.addCSSClassOrLogError(cls);
            }
            if (!svgp.getCSSClassManager().contains(SAV_BUTTON)) {
                cls = new CSSClass(this, SAV_BUTTON);
                cls.setStatement("opacity", 0.01);
                cls.setStatement("fill", "grey");
                cls.setStatement("cursor", "pointer");
                svgp.addCSSClassOrLogError(cls);
            }
            if (!svgp.getCSSClassManager().contains(SAV_CROSS)) {
                cls = new CSSClass(this, SAV_CROSS);
                cls.setStatement("stroke", "black");
                cls.setStatement("stroke-width", style.getLineWidth("plot") * 0.75);
                cls.setStatement("fill", "none");
                svgp.addCSSClassOrLogError(cls);
            }
        }
    }
}

