/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.lines.LineStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;

public class BoundingBoxVisualization
implements VisFactory {
    public static final String NAME = "Spatial objects";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ParallelPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            if (!TypeUtil.SPATIAL_OBJECT.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            context.addVis(p, new VisualizationTask(this, NAME, p.getRelation(), p.getRelation()).level(100).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY).with(VisualizationTask.UpdateFlag.ON_SAMPLE));
        });
    }

    public class Instance
    extends AbstractParallelVisualization<SpatialComparable>
    implements DataStoreListener {
        public static final String DATALINE = "Databox";
        private SamplingResult sample;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.sample = SamplingResult.getSamplingResult(this.relation);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            DBIDs sam = this.sample.getSample();
            StylingPolicy sp = this.context.getStylingPolicy();
            StyleLibrary style = this.context.getStyleLibrary();
            LineStyleLibrary lines = style.lines();
            double width = 0.5 * style.getLineWidth("plot") * MathUtil.min(0.5, 2.0 / MathUtil.log2(sam.size()));
            if (sp instanceof ClassStylingPolicy) {
                ClassStylingPolicy csp = (ClassStylingPolicy)sp;
                int min = csp.getMinStyle();
                String[] keys = new String[csp.getMaxStyle() - min];
                for (int c = min; c < csp.getMaxStyle(); ++c) {
                    String string = "Databox_" + c;
                    keys[c - min] = string;
                    String key = string;
                    if (this.svgp.getCSSClassManager().contains(key)) continue;
                    CSSClass cls = new CSSClass(this, key);
                    cls.setStatement("stroke-linecap", "round");
                    cls.setStatement("stroke-linejoin", "round");
                    cls.setStatement("fill", "none");
                    lines.formatCSSClass(cls, c, width, new Object[0]);
                    this.svgp.addCSSClassOrLogError(cls);
                }
                DBIDIter iter = sam.iter();
                while (iter.valid()) {
                    Element line;
                    int c = csp.getStyleForDBID(iter) + min;
                    if (c >= 0 && (line = this.drawLine(iter)) != null) {
                        SVGUtil.addCSSClass(line, keys[c]);
                        this.layer.appendChild(line);
                    }
                    iter.advance();
                }
            } else {
                if (!this.svgp.getCSSClassManager().contains(DATALINE)) {
                    CSSClass cls = new CSSClass(this, DATALINE);
                    cls.setStatement("stroke-linecap", "round");
                    cls.setStatement("stroke-linejoin", "round");
                    cls.setStatement("fill", "none");
                    lines.formatCSSClass(cls, -1, width, new Object[0]);
                    this.svgp.addCSSClassOrLogError(cls);
                }
                StringBuilder buf = new StringBuilder().append("stroke").append(':');
                int prefix = buf.length();
                DBIDIter iter = sam.iter();
                while (iter.valid()) {
                    Element line = this.drawLine(iter);
                    if (line != null) {
                        SVGUtil.addCSSClass(line, DATALINE);
                        buf.delete(prefix, buf.length());
                        buf.append(SVGUtil.colorToString(sp.getColorForDBID(iter)));
                        line.setAttribute("style", buf.toString());
                        this.layer.appendChild(line);
                    }
                    iter.advance();
                }
            }
            this.svgp.updateStyleElement();
        }

        private Element drawLine(DBIDRef iter) {
            int d;
            int i;
            SVGPath path = new SVGPath();
            SpatialComparable obj = (SpatialComparable)this.relation.get(iter);
            int dims = this.proj.getVisibleDimensions();
            boolean drawn = false;
            int valid = 0;
            double prevpos = Double.NaN;
            for (i = 0; i < dims; ++i) {
                d = this.proj.getDimForAxis(i);
                double minPos = this.proj.fastProjectDataToRenderSpace(obj.getMin(d), i);
                if (minPos != minPos) {
                    valid = 0;
                    continue;
                }
                if (++valid > 1) {
                    if (valid == 2) {
                        path.moveTo(this.getVisibleAxisX(d - 1), prevpos);
                    }
                    path.lineTo(this.getVisibleAxisX(d), minPos);
                    drawn = true;
                }
                prevpos = minPos;
            }
            valid = 0;
            for (i = dims - 1; i >= 0; --i) {
                d = this.proj.getDimForAxis(i);
                double maxPos = this.proj.fastProjectDataToRenderSpace(obj.getMax(d), i);
                if (maxPos != maxPos) {
                    valid = 0;
                    continue;
                }
                if (++valid > 1) {
                    if (valid == 2) {
                        path.moveTo(this.getVisibleAxisX(d + 1), prevpos);
                    }
                    path.lineTo(this.getVisibleAxisX(d), maxPos);
                    drawn = true;
                }
                prevpos = maxPos;
            }
            if (!drawn) {
                return null;
            }
            return path.makeElement(this.svgp);
        }
    }
}

