/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class ParallelAxisVisualization
implements VisFactory {
    private static final Logging LOG = Logging.getLogger(ParallelAxisVisualization.class);
    private static final String NAME = "Parallel Axes";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ParallelPlotProjector.class).forEach(p -> context.addVis(p, new VisualizationTask(this, NAME, p, p.getRelation()).level(0)));
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return true;
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector> {
        public static final String AXIS_LABEL = "paxis-label";
        public static final String INVERTEDAXIS = "paxis-button";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            StyleLibrary style = this.context.getStyleLibrary();
            this.addCSSClasses(this.svgp);
            int dim = this.proj.getInputDimensionality();
            int vdim = 0;
            for (int i = 0; i < dim; ++i) {
                if (!this.proj.isAxisVisible(i)) continue;
                int truedim = this.proj.getDimForAxis(i);
                double axisX = this.getVisibleAxisX(vdim);
                try {
                    if (!this.proj.isAxisInverted(vdim)) {
                        SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, this.proj.getAxisScale(i), axisX, this.getSizeY(), axisX, 0.0, SVGSimpleLinearAxis.LabelStyle.ENDLABEL, style);
                    } else {
                        SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, this.proj.getAxisScale(i), axisX, 0.0, axisX, this.getSizeY(), SVGSimpleLinearAxis.LabelStyle.ENDLABEL, style);
                    }
                }
                catch (CSSClassManager.CSSNamingConflict e) {
                    LOG.warning("Conflict in CSS naming for axes.", e);
                    continue;
                }
                String label = RelationUtil.getColumnLabel(this.relation, truedim);
                Element text = this.svgp.svgText(axisX, -0.7 * this.getMarginTop(), label);
                SVGUtil.setCSSClass(text, AXIS_LABEL);
                if (dim > 10) {
                    SVGUtil.setAtt(text, "textLength", this.getAxisSep() * 0.95);
                    SVGUtil.setAtt(text, "lengthAdjust", "spacingAndGlyphs");
                }
                this.layer.appendChild(text);
                Element button = this.svgp.svgRect(axisX - this.getAxisSep() * 0.475, -this.getMarginTop(), 0.95 * this.getAxisSep(), 0.5 * this.getMarginTop());
                SVGUtil.setCSSClass(button, INVERTEDAXIS);
                this.addEventListener(button, truedim);
                this.layer.appendChild(button);
                ++vdim;
            }
        }

        private void addCSSClasses(SVGPlot svgp) {
            CSSClass cls;
            StyleLibrary style = this.context.getStyleLibrary();
            if (!svgp.getCSSClassManager().contains(AXIS_LABEL)) {
                cls = new CSSClass(this, AXIS_LABEL);
                cls.setStatement("fill", style.getTextColor("axis.label"));
                cls.setStatement("font-family", style.getFontFamily("axis.label"));
                cls.setStatement("font-size", style.getTextSize("axis.label"));
                cls.setStatement("text-anchor", "middle");
                svgp.addCSSClassOrLogError(cls);
            }
            if (!svgp.getCSSClassManager().contains(INVERTEDAXIS)) {
                cls = new CSSClass(this, INVERTEDAXIS);
                cls.setStatement("opacity", 0.1);
                cls.setStatement("fill", "grey");
                svgp.addCSSClassOrLogError(cls);
            }
        }

        private void addEventListener(Element tag, final int truedim) {
            EventTarget targ = (EventTarget)((Object)tag);
            targ.addEventListener("click", new EventListener(){

                @Override
                public void handleEvent(Event evt) {
                    Instance.this.proj.toggleDimInverted(truedim);
                    Instance.this.context.visChanged(Instance.this.proj);
                }
            }, false);
        }
    }
}

