/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster.ClusterHullVisualization;
import java.util.Iterator;

public class ClusterOutlineVisualization
implements VisFactory {
    private static final String NAME = "Cluster Hull (Parallel Coordinates)";
    Parameterizer settings;

    public ClusterOutlineVisualization(Parameterizer settings) {
        this.settings = settings;
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ParallelPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            context.addVis(p, new VisualizationTask(this, NAME, p, rel).level(99).visibility(false).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY));
        });
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID STRAIGHT_ID = new OptionID("parallel.clusteroutline.straight", "Draw straight lines");
        double alpha = Double.POSITIVE_INFINITY;
        private boolean bend = true;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag bendP;
            super.makeOptions(config);
            DoubleParameter alphaP = new DoubleParameter(ClusterHullVisualization.Parameterizer.ALPHA_ID, Double.POSITIVE_INFINITY);
            if (config.grab(alphaP)) {
                this.alpha = alphaP.doubleValue();
            }
            if (config.grab(bendP = new Flag(STRAIGHT_ID))) {
                this.bend = bendP.isFalse();
            }
        }

        @Override
        protected ClusterOutlineVisualization makeInstance() {
            return new ClusterOutlineVisualization(this);
        }
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector>
    implements DataStoreListener {
        public static final String CLUSTERAREA = "Clusteroutline";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            StylingPolicy spol = this.context.getStylingPolicy();
            if (!(spol instanceof ClusterStylingPolicy)) {
                return;
            }
            ClusterStylingPolicy cpol = (ClusterStylingPolicy)spol;
            Clustering<?> clustering = cpol.getClustering();
            int dim = this.proj.getVisibleDimensions();
            DoubleMinMax[] mms = DoubleMinMax.newArray(dim);
            DoubleMinMax[] midmm = DoubleMinMax.newArray(dim - 1);
            double baseopacity = 0.5;
            Iterator<Cluster<?>> ci = clustering.getAllClusters().iterator();
            for (int cnum = 0; cnum < clustering.getAllClusters().size(); ++cnum) {
                int i;
                Cluster<?> clus = ci.next();
                DBIDs ids = clus.getIDs();
                if (ids.size() < 1) continue;
                for (int i2 = 0; i2 < dim; ++i2) {
                    mms[i2].reset();
                    if (i2 >= dim - 1) continue;
                    midmm[i2].reset();
                }
                DBIDIter id = ids.iter();
                while (id.valid()) {
                    double[] yPos = this.proj.fastProjectDataToRenderSpace((NumberVector)this.relation.get(id));
                    for (int i3 = 0; i3 < dim; ++i3) {
                        mms[i3].put(yPos[i3]);
                        if (i3 <= 0) continue;
                        midmm[i3 - 1].put((yPos[i3] + yPos[i3 - 1]) / 2.0);
                    }
                    id.advance();
                }
                SVGPath path = new SVGPath();
                if (!ClusterOutlineVisualization.this.settings.bend) {
                    for (i = 0; i < dim; ++i) {
                        path.drawTo(this.getVisibleAxisX(i), mms[i].getMax());
                        if (i >= dim - 1) continue;
                        path.drawTo(this.getVisibleAxisX((double)i + 0.5), midmm[i].getMax());
                    }
                    for (i = dim - 1; i >= 0; --i) {
                        if (i < dim - 1) {
                            path.drawTo(this.getVisibleAxisX((double)i + 0.5), midmm[i].getMin());
                        }
                        path.drawTo(this.getVisibleAxisX(i), mms[i].getMin());
                    }
                } else {
                    path.drawTo(this.getVisibleAxisX(0.0), mms[0].getMax());
                    for (i = 1; i < dim; ++i) {
                        path.quadTo(this.getVisibleAxisX((double)i - 0.5), midmm[i - 1].getMax(), this.getVisibleAxisX(i), mms[i].getMax());
                    }
                    path.drawTo(this.getVisibleAxisX(dim - 1), mms[dim - 1].getMin());
                    for (i = dim - 1; i > 0; --i) {
                        path.quadTo(this.getVisibleAxisX((double)i - 0.5), midmm[i - 1].getMin(), this.getVisibleAxisX(i - 1), mms[i - 1].getMin());
                    }
                }
                path.close();
                double weight = 0.0;
                for (int i4 = 0; i4 < dim; ++i4) {
                    weight += mms[i4].getDiff();
                }
                weight = weight > 0.0 ? (double)dim * 100.0 / weight : 1.0;
                this.addCSSClasses(this.svgp, cpol.getStyleForCluster(clus), baseopacity * weight * (double)ids.size() / (double)this.relation.size());
                this.layer.appendChild(path.makeElement(this.svgp, CLUSTERAREA + cnum));
            }
        }

        private void addCSSClasses(SVGPlot svgp, int clusterID, double opac) {
            StyleLibrary style = this.context.getStyleLibrary();
            ColorLibrary colors = style.getColorSet("plot");
            CSSClass cls = new CSSClass(this, CLUSTERAREA + clusterID);
            String color = colors.getColor(clusterID);
            cls.setStatement("fill", color);
            cls.setStatement("fill-opacity", opac);
            svgp.addCSSClassOrLogError(cls);
        }
    }
}

