/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.PrototypeModel;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import java.util.Iterator;

public class ClusterParallelMeanVisualization
implements VisFactory {
    private static final String NAME = "Cluster Means";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ParallelPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            context.addVis(p, new VisualizationTask(this, NAME, p, rel).level(101).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY));
        });
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector>
    implements DataStoreListener {
        public static final String CLUSTERMEAN = "Clustermean";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            StylingPolicy spol = this.context.getStylingPolicy();
            if (!(spol instanceof ClusterStylingPolicy)) {
                return;
            }
            Clustering<?> clustering = ((ClusterStylingPolicy)spol).getClustering();
            if (clustering.getAllClusters().size() == 0) {
                return;
            }
            StyleLibrary style = this.context.getStyleLibrary();
            ColorLibrary colors = style.getColorSet("plot");
            Iterator<Cluster<?>> ci = clustering.getAllClusters().iterator();
            for (int cnum = 0; cnum < clustering.getAllClusters().size(); ++cnum) {
                Object model = ci.next().getModel();
                double[] mean = null;
                try {
                    if (model instanceof PrototypeModel) {
                        Object prototype = ((PrototypeModel)model).getPrototype();
                        if (prototype instanceof double[]) {
                            mean = this.proj.fastProjectDataToRenderSpace((double[])prototype);
                        } else if (prototype instanceof DBIDRef) {
                            mean = this.proj.fastProjectDataToRenderSpace((NumberVector)this.relation.get((DBIDRef)prototype));
                        }
                    }
                    if (mean == null) {
                    }
                }
                catch (ObjectNotFoundException e) {}
                continue;
                SVGPath path = new SVGPath();
                for (int i = 0; i < mean.length; ++i) {
                    path.drawTo(this.getVisibleAxisX(i), mean[i]);
                }
                String cnam = CLUSTERMEAN + cnum;
                if (!this.svgp.getCSSClassManager().contains(cnam)) {
                    CSSClass cls = new CSSClass(this, cnam);
                    cls.setStatement("stroke-width", style.getLineWidth("plot") * 2.0);
                    String color = colors.getColor(cnum);
                    cls.setStatement("stroke", color);
                    cls.setStatement("fill", "none");
                    this.svgp.addCSSClassOrLogError(cls);
                }
                this.layer.appendChild(path.makeElement(this.svgp, cnam));
            }
        }
    }
}

