/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.index;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.ProjectionParallel;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.index.TreeMBRVisualization;
import org.w3c.dom.Element;

public class RTreeParallelVisualization
implements VisFactory {
    public static final String INDEX = "parallelrtree";
    public static final String NAME = "R-Tree Index MBRs";
    protected Parameterizer settings;

    public RTreeParallelVisualization(Parameterizer settings) {
        this.settings = settings;
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewSiblings(context, start, AbstractRStarTree.class, ParallelPlotProjector.class, (tree, p) -> {
            VisualizationTask task = new VisualizationTask(this, NAME, tree, p.getRelation()).level(2).visibility(false);
            context.addVis(tree, task);
            context.addVis(p, task);
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected boolean fill = true;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            Flag fillF = (Flag)new Flag(TreeMBRVisualization.Parameterizer.FILL_ID).setDefaultValue(Boolean.TRUE);
            if (config.grab(fillF)) {
                this.fill = fillF.isTrue();
            }
        }

        @Override
        protected RTreeParallelVisualization makeInstance() {
            return new RTreeParallelVisualization(this);
        }
    }

    public class Instance<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry>
    extends AbstractParallelVisualization<NumberVector>
    implements DataStoreListener {
        protected AbstractRStarTree<N, E, ?> tree;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.tree = (AbstractRStarTree)AbstractRStarTree.class.cast(task.getResult());
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            this.addCSSClasses(this.svgp);
            SpatialEntry root = (SpatialEntry)this.tree.getRootEntry();
            this.visualizeRTreeEntry(this.svgp, this.layer, this.proj, this.tree, root, 0, 0);
        }

        private void addCSSClasses(SVGPlot svgp) {
            StyleLibrary style = this.context.getStyleLibrary();
            ColorLibrary colors = style.getColorSet("plot");
            for (int i = 0; i < this.tree.getHeight(); ++i) {
                if (svgp.getCSSClassManager().contains(RTreeParallelVisualization.INDEX + i)) continue;
                CSSClass cls = new CSSClass(this, RTreeParallelVisualization.INDEX + i);
                double relDepth = 1.0 - (double)i / (double)this.tree.getHeight();
                if (RTreeParallelVisualization.this.settings.fill) {
                    cls.setStatement("stroke", colors.getColor(i));
                    cls.setStatement("stroke-width", relDepth * style.getLineWidth("plot"));
                    cls.setStatement("fill", colors.getColor(i));
                    cls.setStatement("fill-opacity", 0.2);
                } else {
                    cls.setStatement("stroke", colors.getColor(i));
                    cls.setStatement("stroke-width", relDepth * style.getLineWidth("plot"));
                    cls.setStatement("fill", "none");
                }
                cls.setStatement("stroke-linecap", "round");
                cls.setStatement("stroke-linejoin", "round");
                svgp.addCSSClassOrLogError(cls);
            }
            svgp.updateStyleElement();
        }

        private void visualizeRTreeEntry(SVGPlot svgp, Element layer, ProjectionParallel proj, AbstractRStarTree<? extends N, E, ?> rtree, E entry, int depth, int step) {
            int i;
            int dim = proj.getVisibleDimensions();
            double[] min = proj.fastProjectDataToRenderSpace(SpatialUtil.getMin(entry));
            double[] max = proj.fastProjectDataToRenderSpace(SpatialUtil.getMax(entry));
            assert (min.length == dim && max.length == dim);
            SVGPath path = new SVGPath();
            for (i = 0; i < dim; ++i) {
                path.drawTo(this.getVisibleAxisX(i), Math.max(min[i], max[i]));
            }
            for (i = dim - 1; i >= 0; --i) {
                path.drawTo(this.getVisibleAxisX(i), Math.min(min[i], max[i]));
            }
            path.close();
            layer.appendChild(path.makeElement(svgp, RTreeParallelVisualization.INDEX + depth));
            if (!(entry instanceof LeafEntry)) {
                AbstractRStarTreeNode node = (AbstractRStarTreeNode)rtree.getNode(entry);
                for (int i2 = 0; i2 < node.getNumEntries(); ++i2) {
                    SpatialEntry child = (SpatialEntry)node.getEntry(i2);
                    if (child instanceof LeafEntry) continue;
                    this.visualizeRTreeEntry(svgp, layer, proj, rtree, child, depth + 1, ++step);
                }
            }
        }
    }
}

