/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.selection;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.RangeSelection;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;

public class SelectionAxisRangeVisualization
implements VisFactory {
    public static final String NAME = "Selection Axis Range";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ParallelPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, context.getSelectionResult(), rel).level(99).with(VisualizationTask.UpdateFlag.ON_SELECTION);
            context.addVis(context.getSelectionResult(), task);
            context.addVis(p, task);
        });
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector> {
        public static final String MARKER = "selectionAxisRange";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        private void addCSSClasses(SVGPlot svgp) {
            StyleLibrary style = this.context.getStyleLibrary();
            if (!svgp.getCSSClassManager().contains(MARKER)) {
                CSSClass cls = new CSSClass(this, MARKER);
                cls.setStatement("stroke", style.getColor("plot.selection"));
                cls.setStatement("stroke-opacity", style.getOpacity("plot.selection"));
                cls.setStatement("stroke-width", style.getLineWidth("plot"));
                cls.setStatement("stroke-linecap", "round");
                cls.setStatement("stroke-linejoin", "round");
                cls.setStatement("fill", style.getColor("plot.selection"));
                cls.setStatement("fill-opacity", style.getOpacity("plot.selection"));
                svgp.addCSSClassOrLogError(cls);
            }
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            this.addCSSClasses(this.svgp);
            DBIDSelection selContext = this.context.getSelection();
            if (!(selContext instanceof RangeSelection)) {
                return;
            }
            ModifiableHyperBoundingBox range = ((RangeSelection)selContext).getRanges();
            if (range == null) {
                return;
            }
            int dims = range.getDimensionality();
            double[] min = new double[dims];
            double[] max = new double[dims];
            for (int d = 0; d < dims; ++d) {
                min[d] = range.getMin(d);
                max[d] = range.getMax(d);
            }
            min = this.proj.fastProjectDataToRenderSpace(min);
            max = this.proj.fastProjectDataToRenderSpace(max);
            int vdim = this.proj.getVisibleDimensions();
            for (int vd = 0; vd < vdim; ++vd) {
                int ad = this.proj.getDimForVisibleAxis(vd);
                double amin = Math.min(min[ad], max[ad]);
                double amax = Math.max(min[ad], max[ad]);
                if (!(amin > Double.MIN_VALUE) || !(amax < Double.MAX_VALUE)) continue;
                Element rect = this.svgp.svgRect(this.getVisibleAxisX(vd) - 1.0, amin, 2.0, amax - amin);
                SVGUtil.addCSSClass(rect, MARKER);
                this.layer.appendChild(rect);
            }
        }
    }
}

