/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.selection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;

public class SelectionLineVisualization
implements VisFactory {
    public static final String NAME = "Selection Line";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ParallelPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, context.getSelectionResult(), rel).level(99).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SELECTION);
            context.addVis(context.getSelectionResult(), task);
            context.addVis(p, task);
        });
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector>
    implements DataStoreListener {
        public static final String MARKER = "SelectionLine";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            this.addCSSClasses(this.svgp);
            DBIDSelection selContext = this.context.getSelection();
            if (selContext != null) {
                DBIDs selection = selContext.getSelectedIds();
                DBIDIter iter = selection.iter();
                while (iter.valid()) {
                    Element marker = this.drawLine(iter);
                    if (marker != null) {
                        SVGUtil.addCSSClass(marker, MARKER);
                        this.layer.appendChild(marker);
                    }
                    iter.advance();
                }
            }
        }

        private Element drawLine(DBIDRef iter) {
            SVGPath path = new SVGPath();
            double[] yPos = this.proj.fastProjectDataToRenderSpace((NumberVector)this.relation.get(iter));
            boolean draw = false;
            boolean drawprev = false;
            boolean drawn = false;
            for (int i = 0; i < yPos.length; ++i) {
                if (yPos[i] != yPos[i]) {
                    draw = false;
                    drawprev = false;
                    continue;
                }
                if (draw) {
                    if (drawprev) {
                        path.moveTo(this.getVisibleAxisX(i - 1), yPos[i - 1]);
                        drawprev = false;
                    }
                    path.lineTo(this.getVisibleAxisX(i), yPos[i]);
                    drawn = true;
                } else {
                    drawprev = true;
                }
                draw = true;
            }
            if (!drawn) {
                return null;
            }
            return path.makeElement(this.svgp);
        }

        private void addCSSClasses(SVGPlot svgp) {
            StyleLibrary style = this.context.getStyleLibrary();
            if (!svgp.getCSSClassManager().contains(MARKER)) {
                CSSClass cls = new CSSClass(this, MARKER);
                cls.setStatement("stroke", style.getColor("plot.selection"));
                cls.setStatement("stroke-opacity", style.getOpacity("plot.selection"));
                cls.setStatement("stroke-width", style.getLineWidth("plot") * 2.0);
                cls.setStatement("stroke-linecap", "round");
                cls.setStatement("stroke-linejoin", "round");
                cls.setStatement("fill", "none");
                svgp.addCSSClassOrLogError(cls);
            }
        }
    }
}

