/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.selection;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.RangeSelection;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class SelectionToolAxisRangeVisualization
implements VisFactory {
    private static final Logging LOG = Logging.getLogger(SelectionToolAxisRangeVisualization.class);
    private static final String NAME = "Axis Range Selection";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ParallelPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, context.getSelectionResult(), rel).level(1000).tool(true).visibility(false).with(VisualizationTask.UpdateFlag.ON_SELECTION).with(VisualizationTask.RenderFlag.NO_THUMBNAIL).with(VisualizationTask.RenderFlag.NO_EXPORT);
            context.addVis(context.getSelectionResult(), task);
            context.addVis(p, task);
        });
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector>
    implements DragableArea.DragListener {
        private static final String CSS_RANGEMARKER = "selectionAxisRangeMarker";
        private Element rtag;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            this.addCSSClasses(this.svgp);
            this.rtag = this.svgp.svgElement("g", CSS_RANGEMARKER);
            this.layer.appendChild(this.rtag);
            this.layer.appendChild(new DragableArea((SVGPlot)this.svgp, -0.1 * this.getMarginLeft(), -0.1 * this.getMarginTop(), this.getSizeX() + this.getMarginLeft() * 0.2, this.getSizeY() + this.getMarginTop() * 0.2, this).getElement());
        }

        private void deleteChildren(Element container) {
            while (container.hasChildNodes()) {
                container.removeChild(container.getLastChild());
            }
        }

        private void updateSelectionRectKoordinates(double x1, double x2, double y1, double y2, ModifiableHyperBoundingBox ranges) {
            double axx;
            int i;
            int dims = this.proj.getVisibleDimensions();
            int minaxis = dims + 1;
            int maxaxis = -1;
            for (i = 0; i < dims; ++i) {
                axx = this.getVisibleAxisX(i);
                if (!(x1 < axx) && !(x2 < axx)) continue;
                minaxis = i;
                break;
            }
            while (i <= dims) {
                axx = this.getVisibleAxisX(i);
                if (x2 < axx && x1 < axx) {
                    maxaxis = i;
                    break;
                }
                ++i;
            }
            double z1 = Math.max(Math.min(y1, y2), 0.0);
            double z2 = Math.min(Math.max(y1, y2), this.getSizeY());
            for (int i2 = minaxis; i2 < maxaxis; ++i2) {
                double v1 = this.proj.fastProjectRenderToDataSpace(z1, i2);
                double v2 = this.proj.fastProjectRenderToDataSpace(z2, i2);
                int ddim = this.proj.getDimForVisibleAxis(i2);
                if (LOG.isDebugging()) {
                    LOG.debug("Axis " + i2 + " dimension " + ddim + " " + v1 + " to " + v2);
                }
                ranges.setMin(ddim, Math.min(v1, v2));
                ranges.setMax(ddim, Math.max(v1, v2));
            }
        }

        @Override
        public boolean startDrag(SVGPoint startPoint, Event evt) {
            return true;
        }

        @Override
        public boolean duringDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
            this.deleteChildren(this.rtag);
            double x = Math.min(startPoint.getX(), dragPoint.getX());
            double y = Math.min(startPoint.getY(), dragPoint.getY());
            double width = Math.abs(startPoint.getX() - dragPoint.getX());
            double height = Math.abs(startPoint.getY() - dragPoint.getY());
            this.rtag.appendChild(this.svgp.svgRect(x, y, width, height));
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
            this.deleteChildren(this.rtag);
            if (startPoint.getX() != dragPoint.getX() || startPoint.getY() != dragPoint.getY()) {
                this.updateSelection(this.proj, startPoint, dragPoint);
            }
            return true;
        }

        private void updateSelection(Projection proj, SVGPoint p1, SVGPoint p2) {
            DBIDSelection selContext = this.context.getSelection();
            HashSetModifiableDBIDs selection = selContext != null ? DBIDUtil.newHashSet(selContext.getSelectedIds()) : DBIDUtil.newHashSet();
            if (p1 == null || p2 == null) {
                LOG.warning("no rect selected: p1: " + p1 + " p2: " + p2);
            } else {
                double x1 = Math.min(p1.getX(), p2.getX());
                double x2 = Math.max(p1.getX(), p2.getX());
                double y1 = Math.max(p1.getY(), p2.getY());
                double y2 = Math.min(p1.getY(), p2.getY());
                int dim = proj.getInputDimensionality();
                ModifiableHyperBoundingBox ranges = selContext instanceof RangeSelection ? ((RangeSelection)selContext).getRanges() : new ModifiableHyperBoundingBox(dim, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                this.updateSelectionRectKoordinates(x1, x2, y1, y2, ranges);
                selection.clear();
                DBIDIter iditer = this.relation.iterDBIDs();
                while (iditer.valid()) {
                    block5: {
                        NumberVector dbTupel = (NumberVector)this.relation.get(iditer);
                        for (int d = 0; d < dim; ++d) {
                            double min = ranges.getMin(d);
                            double max = ranges.getMax(d);
                            if (!(max < Double.POSITIVE_INFINITY) || !(min > Double.NEGATIVE_INFINITY) || !(dbTupel.doubleValue(d) < min) && !(dbTupel.doubleValue(d) > max)) {
                                continue;
                            }
                            break block5;
                        }
                        selection.add(iditer);
                    }
                    iditer.advance();
                }
                this.context.setSelection(new RangeSelection(selection, ranges));
            }
        }

        protected void addCSSClasses(SVGPlot svgp) {
            if (!svgp.getCSSClassManager().contains(CSS_RANGEMARKER)) {
                CSSClass rcls = new CSSClass(this, CSS_RANGEMARKER);
                StyleLibrary style = this.context.getStyleLibrary();
                rcls.setStatement("fill", style.getColor("plot.selection.active"));
                rcls.setStatement("opacity", style.getOpacity("plot.selection.active"));
                svgp.addCSSClassOrLogError(rcls);
            }
        }
    }
}

