/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.selection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import java.awt.geom.Line2D;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class SelectionToolLineVisualization
implements VisFactory {
    private static final String NAME = "Object Selection";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ParallelPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, context.getSelectionResult(), rel).level(1000).tool(true).visibility(false).with(VisualizationTask.UpdateFlag.ON_SELECTION).with(VisualizationTask.RenderFlag.NO_THUMBNAIL).with(VisualizationTask.RenderFlag.NO_EXPORT);
            context.addVis(context.getSelectionResult(), task);
            context.addVis(p, task);
        });
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector>
    implements DragableArea.DragListener {
        private static final String CSS_RANGEMARKER = "selectionRangeMarker";
        Element rtag;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            this.addCSSClasses(this.svgp);
            this.rtag = this.svgp.svgElement("g", CSS_RANGEMARKER);
            this.layer.appendChild(this.rtag);
            this.layer.appendChild(new DragableArea((SVGPlot)this.svgp, -0.1 * this.getMarginLeft(), -0.5 * this.getMarginTop(), this.getSizeX() + 0.2 * this.getMarginLeft(), this.getMarginTop() * 1.5 + this.getSizeY(), this).getElement());
        }

        private void deleteChildren(Element container) {
            while (container.hasChildNodes()) {
                container.removeChild(container.getLastChild());
            }
        }

        @Override
        public boolean startDrag(SVGPoint startPoint, Event evt) {
            return true;
        }

        @Override
        public boolean duringDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
            this.deleteChildren(this.rtag);
            double x = Math.min(startPoint.getX(), dragPoint.getX());
            double y = Math.min(startPoint.getY(), dragPoint.getY());
            double width = Math.abs(startPoint.getX() - dragPoint.getX());
            double height = Math.abs(startPoint.getY() - dragPoint.getY());
            this.rtag.appendChild(this.svgp.svgRect(x, y, width, height));
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint startPoint, SVGPoint dragPoint, Event evt, boolean inside) {
            Mode mode = this.getInputMode(evt);
            this.deleteChildren(this.rtag);
            if (startPoint.getX() != dragPoint.getX() || startPoint.getY() != dragPoint.getY()) {
                this.updateSelection(mode, startPoint, dragPoint);
            }
            return true;
        }

        private Mode getInputMode(Event evt) {
            if (evt instanceof DOMMouseEvent) {
                DOMMouseEvent domme = (DOMMouseEvent)evt;
                return domme.getShiftKey() ? Mode.ADD : (domme.getCtrlKey() ? Mode.INVERT : Mode.REPLACE);
            }
            return Mode.REPLACE;
        }

        private void updateSelection(Mode mode, SVGPoint p1, SVGPoint p2) {
            DBIDSelection selContext = this.context.getSelection();
            HashSetModifiableDBIDs selection = selContext == null || mode == Mode.REPLACE ? DBIDUtil.newHashSet() : DBIDUtil.newHashSet(selContext.getSelectedIds());
            int[] axisrange = this.getAxisRange(Math.min(p1.getX(), p2.getX()), Math.max(p1.getX(), p2.getX()));
            DBIDs ids = SamplingResult.getSamplingResult(this.relation).getSample();
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                double[] yPos = this.proj.fastProjectDataToRenderSpace((NumberVector)this.relation.get(iter));
                if (this.checkSelected(axisrange, yPos, Math.max(p1.getX(), p2.getX()), Math.min(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.min(p1.getY(), p2.getY()))) {
                    if (mode == Mode.INVERT) {
                        if (!selection.add(iter)) {
                            selection.remove(iter);
                        }
                    } else {
                        selection.add(iter);
                    }
                }
                iter.advance();
            }
            this.context.setSelection(new DBIDSelection(selection));
        }

        private int[] getAxisRange(double x1, double x2) {
            int dim = this.proj.getVisibleDimensions();
            int minaxis = 0;
            int maxaxis = 0;
            boolean minx = true;
            int count = -1;
            int i = 0;
            while (i < dim) {
                if (minx && this.getVisibleAxisX(i) > x1) {
                    minaxis = count;
                    minx = false;
                }
                if (!minx && (this.getVisibleAxisX(i) > x2 || i == dim - 1)) {
                    maxaxis = count + 1;
                    if (i != dim - 1 || !(this.getVisibleAxisX(i) <= x2)) break;
                    break;
                }
                count = i++;
            }
            return new int[]{minaxis, ++maxaxis};
        }

        private boolean checkSelected(int[] ar, double[] yPos, double x1, double x2, double y1, double y2) {
            int dim = this.proj.getVisibleDimensions();
            if (ar[0] < 0) {
                ar[0] = 0;
            }
            if (ar[1] >= dim) {
                ar[1] = dim - 1;
            }
            for (int i = ar[0] + 1; i <= ar[1] - 1; ++i) {
                if (!(yPos[i] <= y1) || !(yPos[i] >= y2)) continue;
                return true;
            }
            Line2D.Double idline1 = new Line2D.Double(this.getVisibleAxisX(ar[0]), yPos[ar[0]], this.getVisibleAxisX(ar[0] + 1), yPos[ar[0] + 1]);
            Line2D.Double idline2 = new Line2D.Double(this.getVisibleAxisX(ar[1] - 1), yPos[ar[1] - 1], this.getVisibleAxisX(ar[1]), yPos[ar[1]]);
            Line2D.Double rectline1 = new Line2D.Double(x2, y1, x1, y1);
            Line2D.Double rectline2 = new Line2D.Double(x2, y1, x2, y2);
            Line2D.Double rectline3 = new Line2D.Double(x2, y2, x1, y2);
            if (idline1.intersectsLine(rectline1) || idline1.intersectsLine(rectline2) || idline1.intersectsLine(rectline3)) {
                return true;
            }
            Line2D.Double rectline4 = new Line2D.Double(x1, y1, x1, y2);
            return idline2.intersectsLine(rectline1) || idline2.intersectsLine(rectline4) || idline2.intersectsLine(rectline3);
        }

        protected void addCSSClasses(SVGPlot svgp) {
            if (!svgp.getCSSClassManager().contains(CSS_RANGEMARKER)) {
                CSSClass rcls = new CSSClass(this, CSS_RANGEMARKER);
                StyleLibrary style = this.context.getStyleLibrary();
                rcls.setStatement("fill", style.getColor("plot.selection.active"));
                rcls.setStatement("opacity", style.getOpacity("plot.selection.active"));
                svgp.addCSSClassOrLogError(rcls);
            }
        }
    }

    private static enum Mode {
        REPLACE,
        ADD,
        INVERT;

    }
}

