/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import org.w3c.dom.Element;

public abstract class AbstractScatterplotVisualization
extends AbstractVisualization {
    protected final Projection2D proj;
    protected final Relation<? extends NumberVector> rel;
    protected final SamplingResult sample;

    public AbstractScatterplotVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        super(context, task, plot, width, height);
        this.proj = (Projection2D)proj;
        this.rel = task.getRelation();
        this.sample = task.has(VisualizationTask.UpdateFlag.ON_SAMPLE) ? SamplingResult.getSamplingResult(this.rel) : null;
    }

    protected Element setupCanvas() {
        double margin = this.context.getStyleLibrary().getSize("margin");
        this.layer = AbstractScatterplotVisualization.setupCanvas(this.svgp, this.proj, margin, this.getWidth(), this.getHeight());
        return this.layer;
    }

    public static Element setupCanvas(SVGPlot svgp, Projection2D proj, double margin, double width, double height) {
        CanvasSize canvas = proj.estimateViewport();
        double sizex = canvas.getDiffX();
        double sizey = canvas.getDiffY();
        String transform = SVGUtil.makeMarginTransform(width, height, sizex, sizey, margin) + " translate(" + SVGUtil.fmt(sizex * 0.5) + " " + SVGUtil.fmt(sizey * 0.5) + ")";
        Element layer = SVGUtil.svgElement(svgp.getDocument(), "g");
        SVGUtil.setAtt(layer, "transform", transform);
        return layer;
    }

    @Override
    public void visualizationChanged(VisualizationItem item) {
        super.visualizationChanged(item);
        if (item == this.proj) {
            this.svgp.requestRedraw(this.task, this);
            return;
        }
    }
}

