/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class AbstractTooltipVisualization
extends AbstractScatterplotVisualization
implements DataStoreListener {
    public static final String TOOLTIP_HIDDEN = "tooltip_hidden";
    public static final String TOOLTIP_VISIBLE = "tooltip_visible";
    public static final String TOOLTIP_STICKY = "tooltip_sticky";
    public static final String TOOLTIP_AREA = "tooltip_area";
    EventListener hoverer = new EventListener(){

        @Override
        public void handleEvent(Event evt) {
            AbstractTooltipVisualization.this.handleHoverEvent(evt);
        }
    };

    public AbstractTooltipVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        super(context, task, plot, width, height, proj);
    }

    @Override
    public void fullRedraw() {
        this.setupCanvas();
        this.setupCSS(this.svgp);
        StyleLibrary style = this.context.getStyleLibrary();
        double dotsize = style.getLineWidth("plot");
        DBIDIter id = this.sample.getSample().iter();
        while (id.valid()) {
            double[] v = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(id));
            if (v[0] == v[0] && v[1] == v[1]) {
                Element tooltip = this.makeTooltip(id, v[0], v[1], dotsize);
                SVGUtil.addCSSClass(tooltip, TOOLTIP_HIDDEN);
                Element area = this.svgp.svgRect(v[0] - dotsize, v[1] - dotsize, 2.0 * dotsize, 2.0 * dotsize);
                SVGUtil.addCSSClass(area, TOOLTIP_AREA);
                EventTarget targ = (EventTarget)((Object)area);
                targ.addEventListener("mouseover", this.hoverer, false);
                targ.addEventListener("mouseout", this.hoverer, false);
                targ.addEventListener("click", this.hoverer, false);
                this.layer.appendChild(area);
                this.layer.appendChild(tooltip);
            }
            id.advance();
        }
    }

    protected abstract Element makeTooltip(DBIDRef var1, double var2, double var4, double var6);

    protected void handleHoverEvent(Event evt) {
        if (evt.getTarget() instanceof Element) {
            Element e = (Element)((Object)evt.getTarget());
            Node next = e.getNextSibling();
            if (next instanceof Element) {
                this.toggleTooltip((Element)next, evt.getType());
            } else {
                LoggingUtil.warning("Tooltip sibling not found.");
            }
        } else {
            LoggingUtil.warning("Got event for non-Element?!?");
        }
    }

    protected void toggleTooltip(Element elem, String type) {
        String csscls = elem.getAttribute("class");
        if ("mouseover".equals(type)) {
            if (TOOLTIP_HIDDEN.equals(csscls)) {
                SVGUtil.setAtt(elem, "class", TOOLTIP_VISIBLE);
            }
        } else if ("mouseout".equals(type)) {
            if (TOOLTIP_VISIBLE.equals(csscls)) {
                SVGUtil.setAtt(elem, "class", TOOLTIP_HIDDEN);
            }
        } else if ("click".equals(type)) {
            if (TOOLTIP_STICKY.equals(csscls)) {
                SVGUtil.setAtt(elem, "class", TOOLTIP_HIDDEN);
            }
            if (TOOLTIP_HIDDEN.equals(csscls) || TOOLTIP_VISIBLE.equals(csscls)) {
                SVGUtil.setAtt(elem, "class", TOOLTIP_STICKY);
            }
        }
    }

    protected abstract void setupCSS(SVGPlot var1);
}

