/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import net.jafama.FastMath;
import org.w3c.dom.Element;

public class AxisVisualization
implements VisFactory {
    private static final String NAME = "Axes";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> context.addVis(p, new VisualizationTask(this, NAME, p.getRelation(), p.getRelation()).level(0)));
    }

    @Override
    public boolean allowThumbnails(VisualizationTask task) {
        return false;
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary style = this.context.getStyleLibrary();
            int dim = RelationUtil.dimensionality(this.rel);
            double[] orig = this.proj.fastProjectScaledToRenderSpace(new double[dim]);
            double[] diag = new double[dim];
            for (int d2 = 0; d2 < dim; ++d2) {
                diag[d2] = 1.0;
            }
            diag = this.proj.fastProjectScaledToRenderSpace(diag);
            double diaga = FastMath.atan2(diag[1] - orig[1], diag[0] - orig[0]);
            double alfontsize = 1.1 * style.getTextSize("axis.label");
            CSSClass alcls = new CSSClass(AxisVisualization.class, "unmanaged");
            alcls.setStatement("font-size", SVGUtil.fmt(alfontsize));
            alcls.setStatement("fill", style.getTextColor("axis.label"));
            alcls.setStatement("font-family", style.getFontFamily("axis.label"));
            for (int d = 0; d < dim; ++d) {
                double[] v = new double[dim];
                v[d] = 1.0;
                double[] ax = this.proj.fastProjectScaledToRenderSpace(v);
                boolean righthand = false;
                double axa = FastMath.atan2(ax[1] - orig[1], ax[0] - orig[0]);
                if (axa > diaga || diaga > 0.0 && axa > diaga + Math.PI) {
                    righthand = true;
                }
                if (ax[0] == orig[0] && ax[1] == orig[1]) continue;
                try {
                    SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, this.proj.getScale(d), orig[0], orig[1], ax[0], ax[1], righthand ? SVGSimpleLinearAxis.LabelStyle.RIGHTHAND : SVGSimpleLinearAxis.LabelStyle.LEFTHAND, style);
                    double offx = (double)(righthand ? 1 : -1) * 0.02 * 100.0;
                    double offy = (double)(righthand ? 1 : -1) * 0.02 * 100.0;
                    Element label = this.svgp.svgText(ax[0] + offx, ax[1] + offy, RelationUtil.getColumnLabel(this.rel, d));
                    SVGUtil.setAtt(label, "style", alcls.inlineCSS());
                    SVGUtil.setAtt(label, "text-anchor", righthand ? "start" : "end");
                    this.layer.appendChild(label);
                    continue;
                }
                catch (CSSClassManager.CSSNamingConflict e) {
                    throw new RuntimeException("Conflict in CSS naming for axes.", e);
                }
            }
        }
    }
}

