/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class MarkerVisualization
implements VisFactory {
    private static final String NAME = "Markers";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            context.addVis(p, new VisualizationTask(this, NAME, p, rel).level(100).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SAMPLE).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY));
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String DOTMARKER = "dot";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary style = this.context.getStyleLibrary();
            MarkerLibrary ml = style.markers();
            double marker_size = style.getSize("plot.marker");
            StylingPolicy spol = this.context.getStylingPolicy();
            if (spol instanceof ClassStylingPolicy) {
                ClassStylingPolicy cspol = (ClassStylingPolicy)spol;
                DBIDIter iter = this.sample.getSample().iter();
                while (iter.valid()) {
                    try {
                        NumberVector vec = (NumberVector)this.rel.get(iter);
                        double[] v = this.proj.fastProjectDataToRenderSpace(vec);
                        if (v[0] == v[0] && v[1] == v[1]) {
                            ml.useMarker(this.svgp, this.layer, v[0], v[1], cspol.getStyleForDBID(iter), marker_size);
                        }
                    }
                    catch (ObjectNotFoundException vec) {
                        // empty catch block
                    }
                    iter.advance();
                }
            } else {
                String FILL = "fill:";
                DBIDIter iter = this.sample.getSample().iter();
                while (iter.valid()) {
                    try {
                        double[] v = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(iter));
                        Element dot = this.svgp.svgCircle(v[0], v[1], marker_size);
                        SVGUtil.addCSSClass(dot, DOTMARKER);
                        int col = spol.getColorForDBID(iter);
                        SVGUtil.setAtt(dot, "style", "fill:" + SVGUtil.colorToString(col));
                        this.layer.appendChild(dot);
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        // empty catch block
                    }
                    iter.advance();
                }
            }
        }
    }
}

