/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.spatial.PolygonsObject;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.ArrayListIter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;

public class PolygonVisualization
implements VisFactory {
    private static final String NAME = "Polygons";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object result) {
        VisualizationTree.findNewResultVis(context, result, Relation.class, ScatterPlotProjector.class, (rel, p) -> {
            if (!TypeUtil.POLYGON_TYPE.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            if (RelationUtil.dimensionality(rel) != 2) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, rel, (Relation<?>)rel).level(90).with(VisualizationTask.UpdateFlag.ON_DATA);
            context.addVis(rel, task);
            context.addVis(p, task);
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        public static final String POLYS = "polys";
        protected final Relation<PolygonsObject> rep;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.rep = (Relation)task.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary style = this.context.getStyleLibrary();
            CSSClass css = new CSSClass(this.svgp, POLYS);
            css.setStatement("stroke-width", style.getLineWidth("plot.polygons"));
            css.setStatement("stroke", style.getColor("plot.polygons"));
            css.setStatement("fill", "none");
            this.svgp.addCSSClassOrLogError(css);
            this.svgp.updateStyleElement();
            DBIDIter iditer = this.rep.iterDBIDs();
            while (iditer.valid()) {
                try {
                    PolygonsObject poly = this.rep.get(iditer);
                    if (poly != null) {
                        SVGPath path = new SVGPath();
                        for (Polygon ppoly : poly.getPolygons()) {
                            double[] first = ppoly.get(0);
                            double[] f = this.proj.fastProjectDataToRenderSpace(first);
                            path.moveTo(f[0], f[1]);
                            ArrayListIter<double[]> it = ppoly.iter();
                            while (it.valid()) {
                                if (it.getOffset() != 0) {
                                    double[] p = this.proj.fastProjectDataToRenderSpace(it.get());
                                    path.drawTo(p[0], p[1]);
                                }
                                it.advance();
                            }
                            path.drawTo(f[0], f[1]);
                        }
                        this.layer.appendChild(path.makeElement(this.svgp, POLYS));
                    }
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
                iditer.advance();
            }
        }
    }
}

