/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.ReferencePointsResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.Iterator;
import org.w3c.dom.Element;

public class ReferencePointsVisualization
implements VisFactory {
    private static final String NAME = "Reference Points";

    @Override
    public void processNewResult(VisualizerContext context, Object result) {
        VisualizationTree.findNewSiblings(context, result, ReferencePointsResult.class, ScatterPlotProjector.class, (rp, p) -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, rp, rel).level(100);
            context.addVis(rp, task);
            context.addVis(p, task);
        });
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String REFPOINT = "refpoint";
        protected ReferencePointsResult<? extends NumberVector> result;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.result = (ReferencePointsResult)task.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary style = this.context.getStyleLibrary();
            this.setupCSS(this.svgp);
            Iterator iter = this.result.iterator();
            double dotsize = style.getSize("plot.referencepoints");
            while (iter.hasNext()) {
                NumberVector v = (NumberVector)iter.next();
                double[] projected = this.proj.fastProjectDataToRenderSpace(v);
                Element dot = this.svgp.svgCircle(projected[0], projected[1], dotsize);
                SVGUtil.addCSSClass(dot, REFPOINT);
                this.layer.appendChild(dot);
            }
        }

        private void setupCSS(SVGPlot svgp) {
            StyleLibrary style = this.context.getStyleLibrary();
            CSSClass refpoint = new CSSClass(svgp, REFPOINT);
            refpoint.setStatement("fill", style.getColor("plot.referencepoints"));
            svgp.addCSSClassOrLogError(refpoint);
        }
    }
}

