/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractTooltipVisualization;
import java.text.NumberFormat;
import java.util.Locale;
import org.w3c.dom.Element;

public class TooltipScoreVisualization
implements VisFactory {
    public static final String NAME = "Outlier Score Tooltips";
    public static final String NAME_GEN = " Tooltips";
    protected Parameterizer settings;

    public TooltipScoreVisualization(Parameterizer settings) {
        this.settings = settings;
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object result) {
        ResultHierarchy hier = context.getHierarchy();
        VisualizationTree.findNewSiblings(context, result, OutlierResult.class, ScatterPlotProjector.class, (o, p) -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            this.addTooltips(o.getLongName() + NAME_GEN, o.getScores(), context, (ScatterPlotProjector<?>)p, rel);
        });
        VisualizationTree.findNewSiblings(context, result, Relation.class, ScatterPlotProjector.class, (r, p) -> {
            if (hier.iterParents(r).filter(OutlierResult.class).valid()) {
                return;
            }
            if (!TypeUtil.DOUBLE.isAssignableFromType(r.getDataTypeInformation()) && !TypeUtil.INTEGER.isAssignableFromType(r.getDataTypeInformation())) {
                return;
            }
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            this.addTooltips(r.getLongName() + NAME_GEN, (Relation<?>)r, context, (ScatterPlotProjector<?>)p, rel);
        });
    }

    private void addTooltips(String nam, Relation<?> val, VisualizerContext context, ScatterPlotProjector<?> p, Relation<?> rel) {
        VisualizationTask task = new VisualizationTask(this, nam, val, rel).tool(true).visibility(false).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SAMPLE);
        context.addVis(val, task);
        context.addVis(p, task);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        NumberFormat nf = null;
        public static final OptionID DIGITS_ID = new OptionID("tooltip.digits", "Number of digits to show (e.g. when visualizing outlier scores)");

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter digitsP = (IntParameter)new IntParameter(DIGITS_ID, 4).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (config.grab(digitsP)) {
                int digits = digitsP.intValue();
                this.nf = NumberFormat.getInstance(Locale.ROOT);
                this.nf.setGroupingUsed(false);
                this.nf.setMaximumFractionDigits(digits);
            }
        }

        @Override
        protected TooltipScoreVisualization makeInstance() {
            return new TooltipScoreVisualization(this);
        }
    }

    public class Instance
    extends AbstractTooltipVisualization {
        private Relation<? extends Number> result;
        private double fontsize;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.result = (Relation)task.getResult();
            StyleLibrary style = context.getStyleLibrary();
            this.fontsize = 3.0 * style.getTextSize("plot");
            this.addListeners();
        }

        @Override
        protected Element makeTooltip(DBIDRef id, double x, double y, double dotsize) {
            return this.svgp.svgText(x + dotsize, y + this.fontsize * 0.07, TooltipScoreVisualization.this.settings.nf.format(this.result.get(id).doubleValue()));
        }

        @Override
        protected void setupCSS(SVGPlot svgp) {
            StyleLibrary style = this.context.getStyleLibrary();
            double fontsize = style.getTextSize("plot");
            String fontfamily = style.getFontFamily("plot");
            CSSClass tooltiphidden = new CSSClass(svgp, "tooltip_hidden");
            tooltiphidden.setStatement("font-size", fontsize);
            tooltiphidden.setStatement("font-family", fontfamily);
            tooltiphidden.setStatement("display", "none");
            svgp.addCSSClassOrLogError(tooltiphidden);
            CSSClass tooltipvisible = new CSSClass(svgp, "tooltip_visible");
            tooltipvisible.setStatement("font-size", fontsize);
            tooltipvisible.setStatement("font-family", fontfamily);
            svgp.addCSSClassOrLogError(tooltipvisible);
            CSSClass tooltipsticky = new CSSClass(svgp, "tooltip_sticky");
            tooltipsticky.setStatement("font-size", fontsize);
            tooltipsticky.setStatement("font-family", fontfamily);
            svgp.addCSSClassOrLogError(tooltipsticky);
            CSSClass tooltiparea = new CSSClass(svgp, "tooltip_area");
            tooltiparea.setStatement("fill", "red");
            tooltiparea.setStatement("stroke", "none");
            tooltiparea.setStatement("fill-opacity", "0");
            tooltiparea.setStatement("cursor", "pointer");
            svgp.addCSSClassOrLogError(tooltiparea);
            svgp.updateStyleElement();
        }
    }
}

