/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.ExternalID;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractTooltipVisualization;
import org.w3c.dom.Element;

public class TooltipStringVisualization
implements VisFactory {
    public static final String NAME_ID = "ID Tooltips";
    public static final String NAME_LABEL = "Object Label Tooltips";
    public static final String NAME_CLASS = "Class Label Tooltips";
    public static final String NAME_EID = "External ID Tooltips";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object result) {
        VisualizationTree.findNewSiblings(context, result, Relation.class, ScatterPlotProjector.class, (rep, p) -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            Class clz = rep.getDataTypeInformation().getRestrictionClass();
            if (DBID.class.isAssignableFrom(clz)) {
                this.addTooltips(NAME_ID, rel, context, (Relation<?>)rep, (ScatterPlotProjector<?>)p);
            } else if (ClassLabel.class.isAssignableFrom(rep.getDataTypeInformation().getRestrictionClass())) {
                this.addTooltips(NAME_CLASS, rel, context, (Relation<?>)rep, (ScatterPlotProjector<?>)p);
            } else if (LabelList.class.isAssignableFrom(rep.getDataTypeInformation().getRestrictionClass())) {
                this.addTooltips(NAME_LABEL, rel, context, (Relation<?>)rep, (ScatterPlotProjector<?>)p);
            } else if (ExternalID.class.isAssignableFrom(rep.getDataTypeInformation().getRestrictionClass())) {
                this.addTooltips(NAME_EID, rel, context, (Relation<?>)rep, (ScatterPlotProjector<?>)p);
            }
        });
    }

    private void addTooltips(String name, Relation<?> rel, VisualizerContext context, Relation<?> rep, ScatterPlotProjector<?> p) {
        VisualizationTask task = new VisualizationTask(this, name, rep, rel).tool(true).visibility(false).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SAMPLE);
        context.addVis(rep, task);
        context.addVis(p, task);
    }

    public class Instance
    extends AbstractTooltipVisualization {
        private Relation<?> result;
        private double fontsize;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.result = (Relation)task.getResult();
            StyleLibrary style = context.getStyleLibrary();
            this.fontsize = 3.0 * style.getTextSize("plot");
            this.addListeners();
        }

        @Override
        protected Element makeTooltip(DBIDRef id, double x, double y, double dotsize) {
            Object data = this.result.get(id);
            String label = data == null ? "null" : data.toString();
            label = label == null || label.isEmpty() ? "null" : label;
            return this.svgp.svgText(x + dotsize, y + this.fontsize * 0.07, label);
        }

        @Override
        protected void setupCSS(SVGPlot svgp) {
            StyleLibrary style = this.context.getStyleLibrary();
            double fontsize = style.getTextSize("plot");
            String fontfamily = style.getFontFamily("plot");
            CSSClass tooltiphidden = new CSSClass(svgp, "tooltip_hidden");
            tooltiphidden.setStatement("font-size", fontsize);
            tooltiphidden.setStatement("font-family", fontfamily);
            tooltiphidden.setStatement("display", "none");
            svgp.addCSSClassOrLogError(tooltiphidden);
            CSSClass tooltipvisible = new CSSClass(svgp, "tooltip_visible");
            tooltipvisible.setStatement("font-size", fontsize);
            tooltipvisible.setStatement("font-family", fontfamily);
            svgp.addCSSClassOrLogError(tooltipvisible);
            CSSClass tooltipsticky = new CSSClass(svgp, "tooltip_sticky");
            tooltipsticky.setStatement("font-size", fontsize);
            tooltipsticky.setStatement("font-family", fontfamily);
            svgp.addCSSClassOrLogError(tooltipsticky);
            CSSClass tooltiparea = new CSSClass(svgp, "tooltip_area");
            tooltiparea.setStatement("fill", "red");
            tooltiparea.setStatement("stroke", "none");
            tooltiparea.setStatement("fill-opacity", "0");
            tooltiparea.setStatement("cursor", "pointer");
            svgp.addCSSClassOrLogError(tooltiparea);
        }
    }
}

