/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.CoreObjectsModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.geometry.AlphaShape;
import de.lmu.ifi.dbs.elki.math.geometry.FilteredConvexHull2D;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.ArrayListIter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleObjPair;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterHullVisualization
implements VisFactory {
    private static final String NAME = "Cluster Hull";
    Parameterizer settings;

    public ClusterHullVisualization(Parameterizer settings) {
        this.settings = settings;
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            context.addVis(p, new VisualizationTask(this, NAME, p, rel).level(99).visibility(false).with(VisualizationTask.UpdateFlag.ON_DATA).with(VisualizationTask.UpdateFlag.ON_SAMPLE).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY));
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID ALPHA_ID = new OptionID("hull.alpha", "Alpha value for hull drawing (in projected space!).");
        double alpha = Double.POSITIVE_INFINITY;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter alphaP = new DoubleParameter(ALPHA_ID, Double.POSITIVE_INFINITY);
            if (config.grab(alphaP)) {
                this.alpha = alphaP.doubleValue();
            }
        }

        @Override
        protected ClusterHullVisualization makeInstance() {
            return new ClusterHullVisualization(this);
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String CLUSTERHULL = "cluster-hull";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            double baseopacity;
            this.setupCanvas();
            StylingPolicy spol = this.context.getStylingPolicy();
            if (!(spol instanceof ClusterStylingPolicy)) {
                return;
            }
            ClusterStylingPolicy cpol = (ClusterStylingPolicy)spol;
            Clustering<?> clustering = cpol.getClustering();
            CanvasSize viewp = this.proj.estimateViewport();
            double projarea = viewp.getDiffX() * viewp.getDiffY();
            List<Cluster<?>> clusters = clustering.getAllClusters();
            List<Cluster<?>> topc = clustering.getToplevelClusters();
            Hierarchy<Cluster<Model>> hier = clustering.getClusterHierarchy();
            boolean flat = clusters.size() == topc.size();
            double d = baseopacity = flat ? 0.5 : 0.5;
            if (ClusterHullVisualization.this.settings.alpha >= Double.POSITIVE_INFINITY) {
                HashMap<Object, DoubleObjPair<Polygon>> hullmap = new HashMap<Object, DoubleObjPair<Polygon>>(clusters.size());
                for (Cluster<Model> cluster : topc) {
                    this.buildHullsRecursively(cluster, hier, hullmap);
                }
                for (Cluster<?> cluster : clusters) {
                    double relativeSize;
                    double relativeArea;
                    double hullarea;
                    SVGPath path;
                    DoubleObjPair pair = (DoubleObjPair)hullmap.get(cluster);
                    DoubleObjPair mpair = (DoubleObjPair)hullmap.get(cluster.getModel());
                    if (pair != null && pair.second != null && ((Polygon)pair.second).size() > 1) {
                        path = new SVGPath((Polygon)pair.second);
                        hullarea = SpatialUtil.volume((SpatialComparable)pair.second);
                        relativeArea = 1.0 - hullarea / projarea;
                        relativeSize = pair.first / (double)this.rel.size();
                        double corefact = mpair == null ? 1.0 : 0.5;
                        double opacity = corefact * baseopacity * Math.sqrt(relativeSize * relativeArea);
                        this.addCSSClasses(this.svgp, cpol.getStyleForCluster(cluster), opacity);
                        this.layer.appendChild(path.makeElement(this.svgp, CLUSTERHULL + cpol.getStyleForCluster(cluster)));
                    }
                    if (mpair == null || mpair.second == null || ((Polygon)mpair.second).size() <= 1) continue;
                    path = new SVGPath((Polygon)mpair.second);
                    hullarea = SpatialUtil.volume((SpatialComparable)mpair.second);
                    relativeArea = 1.0 - hullarea / projarea;
                    relativeSize = mpair.first / (double)this.rel.size();
                    double opacity = 0.5 * baseopacity * Math.sqrt(relativeSize * relativeArea);
                    this.addCSSClasses(this.svgp, cpol.getStyleForCluster(cluster), opacity);
                    this.layer.appendChild(path.makeElement(this.svgp, CLUSTERHULL + cpol.getStyleForCluster(cluster)));
                }
            } else {
                for (Cluster<Model> cluster : clusters) {
                    List<Object> polys;
                    ArrayList<double[]> arrayList = new ArrayList<double[]>();
                    double weight = this.addRecursively(arrayList, hier, cluster);
                    if (arrayList.isEmpty()) continue;
                    if (arrayList.size() > 2) {
                        polys = new AlphaShape(arrayList, ClusterHullVisualization.this.settings.alpha * 100.0).compute();
                    } else {
                        polys = new ArrayList<Polygon>(1);
                        polys.add(new Polygon(arrayList));
                    }
                    for (Polygon polygon : polys) {
                        this.addCSSClasses(this.svgp, cpol.getStyleForCluster(cluster), baseopacity * weight / (double)this.rel.size());
                        this.layer.appendChild(new SVGPath(polygon).makeElement(this.svgp, CLUSTERHULL + cpol.getStyleForCluster(cluster)));
                    }
                }
            }
        }

        private DoubleObjPair<Polygon> buildHullsRecursively(Cluster<Model> clu, Hierarchy<Cluster<Model>> hier, Map<Object, DoubleObjPair<Polygon>> hulls) {
            int numc;
            double cweight;
            Model model = clu.getModel();
            DBIDs ids = clu.getIDs();
            boolean coremodel = false;
            DBIDs cids = null;
            if (model instanceof CoreObjectsModel) {
                cids = ((CoreObjectsModel)model).getCoreObjects();
                coremodel = cids.size() > 0;
            }
            FilteredConvexHull2D hull = new FilteredConvexHull2D();
            FilteredConvexHull2D hull2 = coremodel ? new FilteredConvexHull2D() : null;
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                double[] projv = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(iter));
                if (projv[0] == projv[0] && projv[1] == projv[1]) {
                    hull.add(projv);
                    if (coremodel && cids.contains(iter)) {
                        hull2.add(projv);
                    }
                }
                iter.advance();
            }
            double weight = ids.size();
            double d = cweight = coremodel ? (double)cids.size() : 0.0;
            if (hier != null && (numc = hier.numChildren(clu)) > 0) {
                It<Cluster<Model>> iter2 = hier.iterChildren(clu);
                while (iter2.valid()) {
                    DoubleObjPair<Polygon> ipoly;
                    Cluster<Model> iclu = iter2.get();
                    DoubleObjPair<Polygon> poly = hulls.get(iclu);
                    if (poly == null) {
                        poly = this.buildHullsRecursively(iclu, hier, hulls);
                    }
                    ArrayListIter<double[]> vi = ((Polygon)poly.second).iter();
                    while (vi.valid()) {
                        hull.add(vi.get());
                        vi.advance();
                    }
                    if (coremodel && (ipoly = hulls.get(iclu.getModel())) != null) {
                        ArrayListIter<double[]> vi2 = ((Polygon)ipoly.second).iter();
                        while (vi2.valid()) {
                            hull2.add(vi2.get());
                            vi2.advance();
                        }
                        cweight += ipoly.first / (double)numc;
                    }
                    weight += poly.first / (double)numc;
                    iter2.advance();
                }
            }
            DoubleObjPair<Polygon> pair = new DoubleObjPair<Polygon>(weight, hull.getHull());
            hulls.put(clu, pair);
            if (coremodel) {
                hulls.put(model, new DoubleObjPair<Polygon>(cweight, hull2.getHull()));
            }
            return pair;
        }

        private double addRecursively(ArrayList<double[]> hull, Hierarchy<Cluster<Model>> hier, Cluster<Model> clus) {
            DBIDs ids = clus.getIDs();
            double weight = ids.size();
            Iter iter = ids.iter();
            while (iter.valid()) {
                double[] projP = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get((DBIDRef)((Object)iter)));
                if (projP[0] == projP[0] && projP[1] == projP[1]) {
                    hull.add(projP);
                }
                iter.advance();
            }
            iter = hier.iterChildren(clus);
            while (iter.valid()) {
                weight += 0.5 * this.addRecursively(hull, hier, (Cluster)iter.get());
                iter.advance();
            }
            return weight;
        }

        private void addCSSClasses(SVGPlot svgp, int clusterID, double opac) {
            StyleLibrary style = this.context.getStyleLibrary();
            ColorLibrary colors = style.getColorSet("plot");
            CSSClass cls = new CSSClass(this, CLUSTERHULL + clusterID);
            cls.setStatement("stroke-width", 0.5 * style.getLineWidth("plot"));
            String color = colors.getColor(clusterID);
            cls.setStatement("stroke", color);
            cls.setStatement("fill", color);
            cls.setStatement("fill-opacity", opac);
            svgp.addCSSClassOrLogError(cls);
        }
    }
}

