/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.PrototypeModel;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.Iterator;
import org.w3c.dom.Element;

public class ClusterMeanVisualization
implements VisFactory {
    private static final String NAME = "Cluster Means";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> context.addVis(p, new VisualizationTask(this, NAME, p, p.getRelation()).level(101).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY)));
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        private static final String CSS_MEAN_CENTER = "mean-center";
        private static final String CSS_MEAN = "mean-marker";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            CSSClass center;
            this.setupCanvas();
            StylingPolicy spol = this.context.getStylingPolicy();
            if (!(spol instanceof ClusterStylingPolicy)) {
                return;
            }
            Clustering<?> clustering = ((ClusterStylingPolicy)spol).getClustering();
            if (clustering.getAllClusters().size() == 0) {
                return;
            }
            StyleLibrary slib = this.context.getStyleLibrary();
            MarkerLibrary ml = slib.markers();
            double marker_size = slib.getSize("plot.marker");
            if (!this.svgp.getCSSClassManager().contains(CSS_MEAN_CENTER)) {
                center = new CSSClass(this, CSS_MEAN_CENTER);
                center.setStatement("stroke", slib.getTextColor(""));
                center.setStatement("stroke-width", slib.getLineWidth("axis.tick") * 0.5);
                this.svgp.addCSSClassOrLogError(center);
            }
            if (!this.svgp.getCSSClassManager().contains(CSS_MEAN)) {
                center = new CSSClass(this, CSS_MEAN);
                center.setStatement("opacity", "0.7");
                this.svgp.addCSSClassOrLogError(center);
            }
            Iterator<Cluster<?>> ci = clustering.getAllClusters().iterator();
            int cnum = 0;
            while (ci.hasNext()) {
                block12: {
                    Cluster<?> clus = ci.next();
                    Object model = clus.getModel();
                    double[] mean = null;
                    try {
                        if (model instanceof PrototypeModel) {
                            Object prototype = ((PrototypeModel)model).getPrototype();
                            if (prototype instanceof double[]) {
                                mean = this.proj.fastProjectDataToRenderSpace((double[])prototype);
                            } else if (prototype instanceof DBIDRef) {
                                mean = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get((DBIDRef)prototype));
                            }
                        }
                        if (mean == null) {
                        }
                    }
                    catch (ObjectNotFoundException e) {}
                    break block12;
                    Element meanMarker = ml.useMarker(this.svgp, this.layer, (double)mean[0], mean[1], cnum, marker_size * 3.0);
                    SVGUtil.setAtt(meanMarker, "class", CSS_MEAN);
                    Element meanMarkerCenter = this.svgp.svgLine(mean[0] - 0.7, mean[1], mean[0] + 0.7, mean[1]);
                    SVGUtil.setAtt(meanMarkerCenter, "class", CSS_MEAN_CENTER);
                    Element meanMarkerCenter2 = this.svgp.svgLine(mean[0], mean[1] - 0.7, mean[0], mean[1] + 0.7);
                    SVGUtil.setAtt(meanMarkerCenter2, "class", CSS_MEAN_CENTER);
                    this.layer.appendChild(meanMarkerCenter);
                    this.layer.appendChild(meanMarkerCenter2);
                }
                ++cnum;
            }
            this.svgp.updateStyleElement();
        }
    }
}

