/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class ClusterOrderVisualization
implements VisFactory {
    private static final String NAME = "Predecessor Graph";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findNewSiblings(context, start, ClusterOrder.class, ScatterPlotProjector.class, (co, p) -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            VisualizationTask task = new VisualizationTask(this, NAME, co, rel).level(99).visibility(false).with(VisualizationTask.UpdateFlag.ON_DATA);
            context.addVis(co, task);
            context.addVis(p, task);
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        private static final String CSSNAME = "predecessor";
        protected ClusterOrder result;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.result = (ClusterOrder)task.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary style = this.context.getStyleLibrary();
            CSSClass cls = new CSSClass(this, CSSNAME);
            style.lines().formatCSSClass(cls, 0, style.getLineWidth("plot.clusterorder"), new Object[0]);
            this.svgp.addCSSClassOrLogError(cls);
            DBIDVar prev = DBIDUtil.newVar();
            DBIDArrayIter it = this.result.iter();
            while (it.valid()) {
                this.result.getPredecessor(it, prev);
                if (!prev.isEmpty()) {
                    double[] thisVec = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(it));
                    double[] prevVec = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(prev));
                    if (thisVec[0] == thisVec[0] && thisVec[1] == thisVec[1] && prevVec[0] == prevVec[0] && prevVec[1] == prevVec[1]) {
                        Element arrow = this.svgp.svgLine(prevVec[0], prevVec[1], thisVec[0], thisVec[1]);
                        SVGUtil.setCSSClass(arrow, cls.getName());
                        this.layer.appendChild(arrow);
                    }
                }
                it.advance();
            }
        }
    }
}

