/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.PrototypeModel;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.Iterator;

public class ClusterStarVisualization
implements VisFactory {
    private static final String NAME = "Cluster Stars";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            context.addVis(p, new VisualizationTask(this, NAME, p, rel).level(101).visibility(false).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY));
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        private static final String CSS_MEAN_STAR = "mean-star";

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StylingPolicy spol = this.context.getStylingPolicy();
            if (!(spol instanceof ClusterStylingPolicy)) {
                return;
            }
            Clustering<?> clustering = ((ClusterStylingPolicy)spol).getClustering();
            if (clustering.getAllClusters().size() == 0) {
                return;
            }
            StyleLibrary slib = this.context.getStyleLibrary();
            ColorLibrary colors = slib.getColorSet("plot");
            Iterator<Cluster<?>> ci = clustering.getAllClusters().iterator();
            int cnum = 0;
            while (ci.hasNext()) {
                block12: {
                    Cluster<?> clus = ci.next();
                    Object model = clus.getModel();
                    double[] mean = null;
                    try {
                        if (model instanceof PrototypeModel) {
                            Object prototype = ((PrototypeModel)model).getPrototype();
                            if (prototype instanceof double[]) {
                                mean = this.proj.fastProjectDataToRenderSpace((double[])prototype);
                            } else if (prototype instanceof DBIDRef) {
                                mean = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get((DBIDRef)prototype));
                            }
                        }
                        if (mean == null) {
                        }
                    }
                    catch (ObjectNotFoundException e) {}
                    break block12;
                    if (!this.svgp.getCSSClassManager().contains("mean-star_" + cnum)) {
                        CSSClass center = new CSSClass(this, "mean-star_" + cnum);
                        center.setStatement("stroke", colors.getColor(cnum));
                        center.setStatement("stroke-width", slib.getLineWidth("plot"));
                        center.setStatement("opacity", "0.7");
                        this.svgp.addCSSClassOrLogError(center);
                    }
                    SVGPath star = new SVGPath();
                    DBIDIter id = clus.getIDs().iter();
                    while (id.valid()) {
                        star.moveTo(this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(id)));
                        star.drawTo(mean);
                        id.advance();
                    }
                    this.layer.appendChild(star.makeElement(this.svgp, "mean-star_" + cnum));
                }
                ++cnum;
            }
            this.svgp.updateStyleElement();
        }
    }
}

