/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.EMModel;
import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.geometry.FilteredConvexHull2D;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenvalueDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jafama.FastMath;
import org.w3c.dom.Element;

public class EMClusterVisualization
implements VisFactory {
    private static final Logging LOG = Logging.getLogger(EMClusterVisualization.class);
    private static final String NAME = "EM Cluster Models";
    static final double[] SIGMA = new double[]{0.41, 0.223, 0.047};

    @Override
    public Instance makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            context.addVis(p, new VisualizationTask(this, NAME, p, p.getRelation()).level(103).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY));
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String EMBORDER = "EMClusterBorder";
        private static final double KAPPA = 0.5522847498;
        private static final double MKAPPA = -0.5522847498;
        private int opacStyle;
        private int softBorder;
        private int drawStyle;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.opacStyle = 1;
            this.softBorder = 1;
            this.drawStyle = 0;
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StylingPolicy spol = this.context.getStylingPolicy();
            if (!(spol instanceof ClusterStylingPolicy)) {
                return;
            }
            Clustering<?> clustering = ((ClusterStylingPolicy)spol).getClustering();
            List<Cluster<?>> clusters = clustering.getAllClusters();
            if (clusters.size() <= 1) {
                return;
            }
            StyleLibrary style = this.context.getStyleLibrary();
            ColorLibrary colors = style.getColorSet("plot");
            Iterator<Cluster<?>> ci = clusters.iterator();
            for (int cnum = 0; cnum < clusters.size(); ++cnum) {
                Cluster<?> clus = ci.next();
                DBIDs ids = clus.getIDs();
                if (ids.size() <= 0 || !(clus.getModel() instanceof EMModel)) continue;
                EMModel model = (EMModel)clus.getModel();
                String sname = "EMClusterBorder_" + cnum;
                if (!this.svgp.getCSSClassManager().contains(sname)) {
                    CSSClass cls = new CSSClass(this, sname);
                    cls.setStatement("stroke-width", style.getLineWidth("plot") * 0.5);
                    String color = colors.getColor(cnum);
                    if (this.softBorder == 0) {
                        cls.setStatement("stroke", color);
                    }
                    cls.setStatement("fill", color);
                    cls.setStatement("fill-opacity", 0.15);
                    this.svgp.addCSSClassOrLogError(cls);
                }
                double[][] covmat = model.getCovarianceMatrix();
                double[] centroid = model.getMean();
                double[] cent = this.proj.fastProjectDataToRenderSpace(centroid);
                EigenvalueDecomposition evd = new EigenvalueDecomposition(covmat);
                double[] eigenvalues = evd.getRealEigenvalues();
                double[][] eigenvectors = VMath.transpose(evd.getV());
                double[][] pc = new double[eigenvalues.length][];
                for (int i = 0; i < eigenvalues.length; ++i) {
                    pc[i] = this.proj.fastProjectRelativeDataToRenderSpace(VMath.times(eigenvectors[i], FastMath.sqrt(eigenvalues[i])));
                }
                if (this.drawStyle != 0 || eigenvalues.length == 2) {
                    this.drawSphere2D(sname, cent, pc);
                    continue;
                }
                this.drawHullLines(sname, cent, this.makeHullComplex(pc));
            }
        }

        protected void drawSphere2D(String sname, double[] cent, double[][] pc) {
            CSSClass cls = this.opacStyle == 1 ? new CSSClass(null, "temp") : null;
            double[] p1 = new double[2];
            double[] p2 = new double[2];
            double[] p3 = new double[2];
            double[] p4 = new double[2];
            double[] tmp1 = new double[2];
            double[] tmp2 = new double[2];
            for (int dim1 = 0; dim1 < pc.length - 1; ++dim1) {
                for (int dim2 = dim1 + 1; dim2 < pc.length; ++dim2) {
                    for (int i = 1; i <= SIGMA.length; ++i) {
                        this.equalsPlusTimes(p1, cent, pc[dim1], i);
                        this.equalsPlusTimes(p2, cent, pc[dim2], i);
                        this.equalsPlusTimes(p3, cent, pc[dim1], -i);
                        this.equalsPlusTimes(p4, cent, pc[dim2], -i);
                        SVGPath path = new SVGPath();
                        path.moveTo(p1);
                        path.cubicTo(this.equalsPlusTimes(tmp1, p1, pc[dim2], 0.5522847498 * (double)i), this.equalsPlusTimes(tmp2, p2, pc[dim1], 0.5522847498 * (double)i), p2);
                        path.cubicTo(this.equalsPlusTimes(tmp1, p2, pc[dim1], -0.5522847498 * (double)i), this.equalsPlusTimes(tmp2, p3, pc[dim2], 0.5522847498 * (double)i), p3);
                        path.cubicTo(this.equalsPlusTimes(tmp1, p3, pc[dim2], -0.5522847498 * (double)i), this.equalsPlusTimes(tmp2, p4, pc[dim1], -0.5522847498 * (double)i), p4);
                        path.cubicTo(this.equalsPlusTimes(tmp1, p4, pc[dim1], 0.5522847498 * (double)i), this.equalsPlusTimes(tmp2, p1, pc[dim2], -0.5522847498 * (double)i), p1);
                        path.close();
                        Element ellipse = path.makeElement(this.svgp, sname);
                        if (cls != null) {
                            cls.setStatement("fill-opacity", SIGMA[i - 1]);
                            SVGUtil.setAtt(ellipse, "style", cls.inlineCSS());
                        }
                        this.layer.appendChild(ellipse);
                    }
                }
            }
        }

        private double[] equalsPlusTimes(double[] out, double[] x, double[] y, double a) {
            out[0] = y[0] * a + x[0];
            out[1] = y[1] * a + x[1];
            return out;
        }

        protected void drawHullLines(String sname, double[] cent, Polygon chres) {
            if (chres.size() <= 1) {
                return;
            }
            CSSClass cls = this.opacStyle == 1 ? new CSSClass(null, "temp") : null;
            for (int i = 1; i <= SIGMA.length; ++i) {
                SVGPath path = new SVGPath();
                for (int p = 0; p < chres.size(); ++p) {
                    path.drawTo(VMath.plusTimes(cent, chres.get(p), (double)i));
                }
                path.close();
                Element ellipse = path.makeElement(this.svgp, sname);
                if (cls != null) {
                    cls.setStatement("fill-opacity", SIGMA[i - 1]);
                    SVGUtil.setAtt(ellipse, "style", cls.inlineCSS());
                }
                this.layer.appendChild(ellipse);
            }
        }

        protected Polygon makeHull(double[][] pc) {
            FilteredConvexHull2D hull = new FilteredConvexHull2D();
            double[] diag = new double[]{0.0, 0.0};
            for (int j = 0; j < pc.length; ++j) {
                hull.add(pc[j]);
                hull.add(VMath.times(pc[j], -1.0));
                for (int k = j + 1; k < pc.length; ++k) {
                    double[] q = pc[k];
                    double[] ppq = VMath.timesEquals(VMath.plus(pc[j], q), MathUtil.SQRTHALF);
                    double[] pmq = VMath.timesEquals(VMath.minus(pc[j], q), MathUtil.SQRTHALF);
                    hull.add(ppq);
                    hull.add(VMath.times(ppq, -1.0));
                    hull.add(pmq);
                    hull.add(VMath.times(pmq, -1.0));
                }
                VMath.plusEquals(diag, pc[j]);
            }
            VMath.timesEquals(diag, 1.0 / FastMath.sqrt(pc.length));
            hull.add(diag);
            hull.add(VMath.times(diag, -1.0));
            return hull.getHull();
        }

        protected Polygon makeHullComplex(double[][] pc) {
            FilteredConvexHull2D hull = new FilteredConvexHull2D();
            double[] diag = new double[]{0.0, 0.0};
            for (int j = 0; j < pc.length; ++j) {
                hull.add(pc[j]);
                hull.add(VMath.times(pc[j], -1.0));
                for (int k = j + 1; k < pc.length; ++k) {
                    double[] q = pc[k];
                    double[] ppq = VMath.timesEquals(VMath.plus(pc[j], q), MathUtil.SQRTHALF);
                    double[] pmq = VMath.timesEquals(VMath.minus(pc[j], q), MathUtil.SQRTHALF);
                    hull.add(ppq);
                    hull.add(VMath.times(ppq, -1.0));
                    hull.add(pmq);
                    hull.add(VMath.times(pmq, -1.0));
                    for (int l = k + 1; l < pc.length; ++l) {
                        double[] r = pc[k];
                        double[] ppqpr = VMath.timesEquals(VMath.plus(ppq, r), MathUtil.SQRTTHIRD);
                        double[] pmqpr = VMath.timesEquals(VMath.plus(pmq, r), MathUtil.SQRTTHIRD);
                        double[] ppqmr = VMath.timesEquals(VMath.minus(ppq, r), MathUtil.SQRTTHIRD);
                        double[] pmqmr = VMath.timesEquals(VMath.minus(pmq, r), MathUtil.SQRTTHIRD);
                        hull.add(ppqpr);
                        hull.add(VMath.times(ppqpr, -1.0));
                        hull.add(pmqpr);
                        hull.add(VMath.times(pmqpr, -1.0));
                        hull.add(ppqmr);
                        hull.add(VMath.times(ppqmr, -1.0));
                        hull.add(pmqmr);
                        hull.add(VMath.times(pmqmr, -1.0));
                    }
                }
                VMath.plusEquals(diag, pc[j]);
            }
            VMath.timesEquals(diag, 1.0 / FastMath.sqrt(pc.length));
            hull.add(diag);
            hull.add(VMath.times(diag, -1.0));
            return hull.getHull();
        }

        protected void drawHullArc(String sname, double[] cent, Polygon chres) {
            if (chres.size() <= 1) {
                return;
            }
            CSSClass cls = this.opacStyle == 1 ? new CSSClass(null, "temp") : null;
            for (int i = 1; i <= SIGMA.length; ++i) {
                int p;
                SVGPath path = new SVGPath();
                ArrayList<double[]> delta = new ArrayList<double[]>(chres.size());
                for (p = 0; p < chres.size(); ++p) {
                    double[] prev = chres.get((p - 1 + chres.size()) % chres.size());
                    double[] curr = chres.get(p);
                    double[] next = chres.get((p + 1) % chres.size());
                    double[] d1 = VMath.normalize(VMath.minus(next, curr));
                    double[] d2 = VMath.normalize(VMath.minus(curr, prev));
                    delta.add(VMath.plus(d1, d2));
                }
                for (p = 0; p < chres.size(); ++p) {
                    double[] cur = VMath.plus(cent, chres.get(p));
                    double[] nex = VMath.plus(cent, chres.get((p + 1) % chres.size()));
                    double[] dcur = (double[])delta.get(p);
                    double[] dnex = (double[])delta.get((p + 1) % chres.size());
                    this.drawArc(path, cent, cur, nex, dcur, dnex, i);
                }
                path.close();
                Element ellipse = path.makeElement(this.svgp, sname);
                if (cls != null) {
                    cls.setStatement("fill-opacity", SIGMA[i - 1]);
                    SVGUtil.setAtt(ellipse, "style", cls.inlineCSS());
                }
                this.layer.appendChild(ellipse);
            }
        }

        private void drawArc(SVGPath path, double[] cent, double[] pre, double[] nex, double[] oPrev, double[] oNext, double scale) {
            double[] rPrev = VMath.minus(pre, cent);
            double[] rNext = VMath.minus(nex, cent);
            double[] rPrNe = VMath.minus(pre, nex);
            double[] sPrev = VMath.plusTimes(cent, rPrev, scale);
            double[] sNext = VMath.plusTimes(cent, rNext, scale);
            double zp = rPrNe[0] * oNext[1] - rPrNe[1] * oNext[0];
            double zn = rPrNe[0] * oPrev[1] - rPrNe[1] * oPrev[0];
            double n = oPrev[1] * oNext[0] - oPrev[0] * oNext[1];
            if (n == 0.0) {
                LOG.warning("Parallel?!?");
                path.drawTo(sNext[0], sNext[1]);
                return;
            }
            double tp = Math.abs(zp / n);
            double tn = Math.abs(zn / n);
            double[] gPrev = VMath.plusTimes(sPrev, oPrev, 0.5522847498 * scale * tp);
            double[] gNext = VMath.minusTimes(sNext, oNext, 0.5522847498 * scale * tn);
            if (!path.isStarted()) {
                path.moveTo(sPrev);
            }
            path.cubicTo(gPrev, gNext, sNext);
        }
    }
}

