/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.math.geometry.SweepHullDelaunay2D;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationMenuAction;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.VoronoiDraw;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class VoronoiVisualization
implements VisFactory {
    private static final String NAME = "k-means Voronoi cells";
    private static final String KMEANSBORDER = "kmeans-border";
    private Mode mode;

    public VoronoiVisualization(Mode mode) {
        this.mode = mode;
    }

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            VisualizationTask task = new VisualizationTask(this, NAME, p, p.getRelation()).level(103).with(VisualizationTask.UpdateFlag.ON_STYLEPOLICY);
            context.addVis(p, task);
            context.addVis(p, new SwitchModeAction(task, context));
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MODE_ID = new OptionID("voronoi.mode", "Mode for drawing the voronoi cells (and/or delaunay triangulation)");
        protected Mode mode;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            EnumParameter<Mode> modeP = new EnumParameter<Mode>(MODE_ID, Mode.class, Mode.VORONOI);
            if (config.grab(modeP)) {
                this.mode = (Mode)((Object)modeP.getValue());
            }
        }

        @Override
        protected VoronoiVisualization makeInstance() {
            return new VoronoiVisualization(this.mode);
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        Element voronoi;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StylingPolicy spol = this.context.getStylingPolicy();
            if (!(spol instanceof ClusterStylingPolicy)) {
                return;
            }
            Clustering<?> clustering = ((ClusterStylingPolicy)spol).getClustering();
            if (clustering.getAllClusters().size() <= 1) {
                return;
            }
            int dim = this.proj.getInputDimensionality();
            if (dim != 2) {
                return;
            }
            this.addCSSClasses(this.svgp);
            List<Cluster<?>> clusters = clustering.getAllClusters();
            ArrayList<double[]> means = new ArrayList<double[]>(clusters.size());
            for (Cluster<?> clus : clusters) {
                double[] mean;
                Object model = clus.getModel();
                try {
                    if (model instanceof KMeansModel) {
                        mean = ((KMeansModel)model).getMean();
                        if (mean == null || mean.length != dim) {
                        }
                    } else {
                        NumberVector v;
                        DBID medoid;
                        if (!(model instanceof MedoidModel) || (medoid = ((MedoidModel)model).getMedoid()) == null || (v = (NumberVector)this.rel.get(medoid)) == null) continue;
                        mean = v.toArray();
                        if (mean.length != dim) {
                        }
                    }
                }
                catch (ObjectNotFoundException e) {}
                continue;
                means.add(mean);
            }
            if (means.size() < 2) {
                return;
            }
            if (means.size() == 2) {
                if (VoronoiVisualization.this.mode == Mode.VORONOI || VoronoiVisualization.this.mode == Mode.V_AND_D) {
                    this.layer.appendChild(VoronoiDraw.drawFakeVoronoi(this.proj, means).makeElement(this.svgp, VoronoiVisualization.KMEANSBORDER));
                }
                if (VoronoiVisualization.this.mode == Mode.DELAUNAY || VoronoiVisualization.this.mode == Mode.V_AND_D) {
                    this.layer.appendChild(new SVGPath(this.proj.fastProjectDataToRenderSpace(means.get(0))).drawTo(this.proj.fastProjectDataToRenderSpace(means.get(1))).makeElement(this.svgp, VoronoiVisualization.KMEANSBORDER));
                }
            } else {
                ArrayList<SweepHullDelaunay2D.Triangle> delaunay = new SweepHullDelaunay2D(means).getDelaunay();
                if (VoronoiVisualization.this.mode == Mode.VORONOI || VoronoiVisualization.this.mode == Mode.V_AND_D) {
                    this.layer.appendChild(VoronoiDraw.drawVoronoi(this.proj, delaunay, means).makeElement(this.svgp, VoronoiVisualization.KMEANSBORDER));
                }
                if (VoronoiVisualization.this.mode == Mode.DELAUNAY || VoronoiVisualization.this.mode == Mode.V_AND_D) {
                    this.layer.appendChild(VoronoiDraw.drawDelaunay(this.proj, delaunay, means).makeElement(this.svgp, VoronoiVisualization.KMEANSBORDER));
                }
            }
        }

        private void addCSSClasses(SVGPlot svgp) {
            if (!svgp.getCSSClassManager().contains(VoronoiVisualization.KMEANSBORDER)) {
                StyleLibrary style = this.context.getStyleLibrary();
                CSSClass cls = new CSSClass(this, VoronoiVisualization.KMEANSBORDER);
                cls = new CSSClass(this, VoronoiVisualization.KMEANSBORDER);
                cls.setStatement("stroke", "black");
                cls.setStatement("stroke-width", style.getLineWidth("plot") * 0.5);
                cls.setStatement("fill", "none");
                cls.setStatement("stroke-linecap", "round");
                cls.setStatement("stroke-linejoin", "round");
                svgp.addCSSClassOrLogError(cls);
            }
        }
    }

    public class SwitchModeAction
    implements VisualizationMenuAction {
        private VisualizationTask task;
        private VisualizerContext context;

        public SwitchModeAction(VisualizationTask task, VisualizerContext context) {
            this.task = task;
            this.context = context;
        }

        @Override
        public String getMenuName() {
            return "Switch Voronoi Mode";
        }

        @Override
        public void activate() {
            switch (VoronoiVisualization.this.mode) {
                case VORONOI: {
                    VoronoiVisualization.this.mode = Mode.DELAUNAY;
                    break;
                }
                case DELAUNAY: {
                    VoronoiVisualization.this.mode = Mode.V_AND_D;
                    break;
                }
                case V_AND_D: {
                    VoronoiVisualization.this.mode = Mode.VORONOI;
                }
            }
            this.context.visChanged(this.task);
        }
    }

    public static enum Mode {
        VORONOI,
        DELAUNAY,
        V_AND_D;

    }
}

