/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.density;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.KMLOutputHandler;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.ThumbnailRegistryEntry;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import net.jafama.FastMath;
import org.w3c.dom.Element;

public class DensityEstimationOverlay
implements VisFactory {
    private static final String NAME = "Density estimation overlay";

    @Override
    public Visualization makeVisualization(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
        return new Instance(context, task, plot, width, height, proj);
    }

    @Override
    public void processNewResult(VisualizerContext context, Object start) {
        VisualizationTree.findVis(context, start).filter(ScatterPlotProjector.class).forEach(p -> {
            Relation rel = p.getRelation();
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) {
                return;
            }
            context.addVis(p, new VisualizationTask(this, NAME, rel, p.getRelation()).level(101).visibility(false).with(VisualizationTask.UpdateFlag.ON_DATA));
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        private int resolution;
        private BufferedImage img;

        public Instance(VisualizerContext context, VisualizationTask task, VisualizationPlot plot, double width, double height, Projection proj) {
            super(context, task, plot, width, height, proj);
            this.resolution = 500;
            this.img = null;
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            if (this.img == null) {
                this.renderImage();
            }
            CanvasSize canvas = this.proj.estimateViewport();
            String imguri = "thumb:" + ThumbnailRegistryEntry.registerImage(this.img);
            Element itag = this.svgp.svgElement("image");
            SVGUtil.setAtt(itag, "image-rendering", "optimizeSpeed");
            SVGUtil.setAtt(itag, "x", canvas.minx);
            SVGUtil.setAtt(itag, "y", canvas.miny);
            SVGUtil.setAtt(itag, "width", canvas.maxx - canvas.minx);
            SVGUtil.setAtt(itag, "height", canvas.maxy - canvas.miny);
            SVGUtil.setAtt(itag, "style", "opacity: .5");
            itag.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", imguri);
            this.layer.appendChild(itag);
        }

        @Reference(authors="D. W. Scott", title="Multivariate density estimation: Theory, Practice, and Visualization", booktitle="Multivariate Density Estimation: Theory, Practice, and Visualization", url="https://doi.org/10.1002/9780470316849", bibkey="doi:10.1002/9780470316849")
        private double[] initializeBandwidth(double[][] data) {
            MeanVariance mv0 = new MeanVariance();
            MeanVariance mv1 = new MeanVariance();
            for (double[] projected : data) {
                mv0.put(projected[0]);
                mv1.put(projected[1]);
            }
            double[] bandwidth = new double[]{MathUtil.SQRT5 * mv0.getSampleStddev() * FastMath.pow(this.rel.size(), -0.16666666666666666), MathUtil.SQRT5 * mv1.getSampleStddev() * FastMath.pow(this.rel.size(), -0.16666666666666666)};
            return bandwidth;
        }

        private void renderImage() {
            int x;
            double[][] data = new double[this.rel.size()][];
            int i = 0;
            DBIDIter iditer = this.rel.iterDBIDs();
            while (iditer.valid()) {
                data[i] = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(iditer));
                ++i;
                iditer.advance();
            }
            double[] bandwidth = this.initializeBandwidth(data);
            Comparator<double[]> comp0 = new Comparator<double[]>(){

                @Override
                public int compare(double[] o1, double[] o2) {
                    return Double.compare(o1[0], o2[0]);
                }
            };
            Comparator<double[]> comp1 = new Comparator<double[]>(){

                @Override
                public int compare(double[] o1, double[] o2) {
                    return Double.compare(o1[1], o2[1]);
                }
            };
            Arrays.sort(data, comp0);
            CanvasSize canvas = this.proj.estimateViewport();
            double min0 = canvas.minx;
            double max0 = canvas.maxx;
            double ste0 = (max0 - min0) / (double)this.resolution;
            double min1 = canvas.miny;
            double max1 = canvas.maxy;
            double ste1 = (max1 - min1) / (double)this.resolution;
            double kernf = 9.0 / (16.0 * bandwidth[0] * bandwidth[1]);
            double maxdens = 0.0;
            double[][] dens = new double[this.resolution][this.resolution];
            for (x = 0; x < this.resolution; ++x) {
                double xlow = min0 + ste0 * (double)x;
                double xhig = xlow + ste0;
                int loff = this.unflip(Arrays.binarySearch(data, new double[]{xlow - bandwidth[0]}, comp0));
                int roff = this.unflip(Arrays.binarySearch(data, new double[]{xhig + bandwidth[0]}, comp0));
                Arrays.sort(data, loff, roff, comp1);
                for (int y = 0; y < this.resolution; ++y) {
                    double ylow = min1 + ste1 * (double)y;
                    double yhig = ylow + ste1;
                    int boff = this.unflip(Arrays.binarySearch(data, loff, roff, new double[]{0.0, ylow - bandwidth[1]}, comp1));
                    int toff = this.unflip(Arrays.binarySearch(data, loff, roff, new double[]{0.0, yhig + bandwidth[1]}, comp1));
                    for (int pos = boff; pos < toff; ++pos) {
                        double d0;
                        double[] val = data[pos];
                        double d = val[0] < xlow ? xlow - val[0] : (d0 = val[0] > xhig ? val[0] - xhig : 0.0);
                        double d1 = val[1] < ylow ? ylow - val[1] : (val[1] > yhig ? val[1] - yhig : 0.0);
                        double[] dArray = dens[x];
                        int n = y;
                        dArray[n] = dArray[n] + kernf * (1.0 - (d0 /= bandwidth[0]) * d0) * (1.0 - (d1 /= bandwidth[1]) * d1);
                    }
                    maxdens = Math.max(maxdens, dens[x][y]);
                }
                Arrays.sort(data, loff, roff, comp0);
            }
            this.img = new BufferedImage(this.resolution, this.resolution, 2);
            for (x = 0; x < this.resolution; ++x) {
                for (int y = 0; y < this.resolution; ++y) {
                    int rgb = KMLOutputHandler.getColorForValue(dens[x][y] / maxdens).getRGB();
                    this.img.setRGB(x, y, rgb);
                }
            }
        }

        private int unflip(int binarySearch) {
            if (binarySearch < 0) {
                return -binarySearch - 1;
            }
            return binarySearch;
        }
    }
}

